/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;

public class GourmaryllisBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_DIGESTING_MANA = "digestingMana";
    public static final String TAG_LAST_FOODS = "lastFoods";
    public static final String TAG_LAST_FOOD_COUNT = "lastFoodCount";
    public static final String TAG_STREAK_LENGTH = "streakLength";
    private static final int RANGE = 1;
    private static final double[] STREAK_MULTIPLIERS = new double[]{0.0, 1.0, 1.3, 1.5, 1.6, 1.7, 1.75, 1.8};
    private static final int MAX_FOOD_VALUE = 12;
    private static final int FOOD_COOLDOWN_FACTOR = 10;
    private static final int FOOD_MANA_FACTOR = 70;
    private static final int MAX_MANA = GourmaryllisBlockEntity.getDigestingMana(12, STREAK_MULTIPLIERS[STREAK_MULTIPLIERS.length - 1]);
    private int cooldown = 0;
    private int digestingMana = 0;
    private final List<class_1799> lastFoods = new LinkedList<class_1799>();
    private int streakLength = -1;
    private int lastFoodCount = 0;

    public GourmaryllisBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaFlowerBlocks.GOURMARYLLIS, pos, state);
    }

    private int getMaxStreak() {
        return STREAK_MULTIPLIERS.length - 1;
    }

    private double getMultiplierForStreak(int index) {
        if (index == 0) {
            return 1.0 / (double)(++this.lastFoodCount);
        }
        this.lastFoodCount = 1;
        return STREAK_MULTIPLIERS[index];
    }

    private int processFood(class_1799 food) {
        ListIterator<class_1799> it = this.lastFoods.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            class_1799 streakFood = it.next();
            if (!class_1799.method_31577((class_1799)streakFood, (class_1799)food)) continue;
            it.remove();
            this.lastFoods.add(0, streakFood);
            return index;
        }
        class_1799 newestFood = food.method_46651(1);
        this.lastFoods.add(0, newestFood);
        if (this.lastFoods.size() >= this.getMaxStreak()) {
            this.lastFoods.remove(this.lastFoods.size() - 1);
        }
        return this.getMaxStreak();
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().field_9236) {
            return;
        }
        if (this.cooldown > -1) {
            --this.cooldown;
        }
        if (this.digestingMana != 0) {
            int munchInterval = 2 + 2 * this.lastFoodCount;
            if (this.cooldown == 0) {
                this.addMana(this.digestingMana);
                this.digestingMana = 0;
                float burpPitch = (float)Math.pow(2.0, (double)(this.streakLength == 0 ? -this.lastFoodCount : this.streakLength) / 12.0);
                this.method_10997().method_8396(null, this.getEffectivePos(), class_3417.field_19149, class_3419.field_15245, 1.0f, burpPitch);
                this.sync();
            } else if (this.cooldown % munchInterval == 0) {
                this.method_10997().method_8396(null, this.getEffectivePos(), class_3417.field_20614, class_3419.field_15245, 0.5f, 1.0f);
                class_243 offset = this.method_10997().method_8320(this.getEffectivePos()).method_26226((class_1922)this.method_10997(), this.getEffectivePos()).method_1031(0.4, 0.6, 0.4);
                ((class_3218)this.method_10997()).method_14199((class_2394)new class_2392(class_2398.field_11218, this.lastFoods.get(0)), (double)this.getEffectivePos().method_10263() + offset.field_1352, (double)this.getEffectivePos().method_10264() + offset.field_1351, (double)this.getEffectivePos().method_10260() + offset.field_1350, 10, 0.1, 0.1, 0.1, 0.03);
            }
        }
        List items = this.method_10997().method_18467(class_1542.class, new class_238(this.getEffectivePos().method_10069(-1, -1, -1), this.getEffectivePos().method_10069(2, 2, 2)));
        for (class_1542 item : items) {
            class_1799 stack = item.method_6983();
            if (!DelayHelper.canInteractWithImmediate(this, item) || !stack.method_7909().method_19263()) continue;
            if (this.cooldown <= 0) {
                this.streakLength = Math.min(this.streakLength + 1, this.processFood(stack));
                int val = GourmaryllisBlockEntity.getFoodValue(stack);
                this.digestingMana = GourmaryllisBlockEntity.getDigestingMana(val, this.getMultiplierForStreak(this.streakLength));
                this.cooldown = GourmaryllisBlockEntity.getCooldown(val);
                item.method_5783(class_3417.field_20614, 0.2f, 0.6f);
                this.sync();
                ((class_3218)this.method_10997()).method_14199((class_2394)new class_2392(class_2398.field_11218, stack), item.method_23317(), item.method_23318(), item.method_23321(), 20, 0.1, 0.1, 0.1, 0.05);
            }
            item.method_31472();
        }
    }

    private static int getCooldown(int foodValue) {
        return foodValue * 10;
    }

    private static int getDigestingMana(int foodValue, double streakFactor) {
        return (int)((double)(foodValue * foodValue * 70) * streakFactor);
    }

    private static int getFoodValue(class_1799 stack) {
        return Math.min(12, stack.method_7909().method_19264().method_19230());
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_COOLDOWN, this.cooldown);
        cmp.method_10569(TAG_DIGESTING_MANA, this.digestingMana);
        class_2499 foodList = new class_2499();
        for (class_1799 food : this.lastFoods) {
            foodList.add((Object)food.method_7953(new class_2487()));
        }
        cmp.method_10566(TAG_LAST_FOODS, (class_2520)foodList);
        cmp.method_10569(TAG_LAST_FOOD_COUNT, this.lastFoodCount);
        cmp.method_10569(TAG_STREAK_LENGTH, this.streakLength);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.method_10550(TAG_COOLDOWN);
        this.digestingMana = cmp.method_10550(TAG_DIGESTING_MANA);
        this.lastFoods.clear();
        class_2499 foodList = cmp.method_10554(TAG_LAST_FOODS, 10);
        for (int i = 0; i < foodList.size(); ++i) {
            this.lastFoods.add(class_1799.method_7915((class_2487)foodList.method_10602(i)));
        }
        this.lastFoodCount = cmp.method_10550(TAG_LAST_FOOD_COUNT);
        this.streakLength = cmp.method_10550(TAG_STREAK_LENGTH);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return MAX_MANA;
    }

    @Override
    public int getColor() {
        return 13882884;
    }
}

