/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class OrechidBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;

    protected OrechidBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public OrechidBlockEntity(class_2338 pos, class_2680 state) {
        this(BotaniaFlowerBlocks.ORECHID, pos, state);
    }

    @Override
    public void tickFlower() {
        class_2338 coords;
        super.tickFlower();
        if (this.method_10997().field_9236 || this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        if (this.getMana() >= this.getCost() && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null) {
            this.trySetRecipe(coords, this.findMatchingRecipe(coords));
        }
    }

    protected void playSound(class_2338 coords) {
        this.method_10997().method_8396(null, coords, BotaniaSounds.orechid, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Nullable
    private OrechidRecipe findMatchingRecipe(class_2338 coords) {
        class_2680 input = this.field_11863.method_8320(coords);
        ArrayList<class_6008.class_6010> values = new ArrayList<class_6008.class_6010>();
        for (OrechidRecipe orechidRecipe : OrechidManager.getMatchingRecipes(this.method_10997().method_8433(), this.getRecipeType(), input)) {
            values.add(class_6008.method_34980((Object)orechidRecipe, (int)orechidRecipe.getWeight(this.method_10997(), coords)));
        }
        return class_6011.method_34986((class_5819)this.method_10997().field_9229, values).map(class_6008.class_6010::method_34983).orElse(null);
    }

    private void trySetRecipe(class_2338 coords, @Nullable OrechidRecipe recipe) {
        if (recipe == null) {
            return;
        }
        class_2680 state = recipe.getOutput(this.field_11863, coords).pick(this.field_11863.field_9229);
        if (this.method_10997().method_8501(coords, state)) {
            if (BotaniaConfig.common().blockBreakParticles()) {
                this.method_10997().method_20290(2001, coords, class_2248.method_9507((class_2680)state));
            }
            this.playSound(coords);
            this.addMana(-this.getCost());
            class_3218 serverLevel = (class_3218)this.field_11863;
            MinecraftServer server = serverLevel.method_8503();
            recipe.getSuccessFunction().method_9196(server.method_3740()).ifPresent(command -> {
                class_2168 context = server.method_3740().method_12899().method_9227(serverLevel).method_9208(class_243.method_24955((class_2382)coords));
                server.method_3740().method_12904(command, context);
            });
            this.sync();
        }
    }

    private class_2338 getCoordsToPut() {
        ArrayList<class_2338> possibleCoords = new ArrayList<class_2338>();
        Predicate<class_2680> matcher = this.getReplaceMatcher();
        for (class_2338 pos : class_2338.method_10097((class_2338)this.getEffectivePos().method_10069(-this.getRange(), -this.getRangeY(), -this.getRange()), (class_2338)this.getEffectivePos().method_10069(this.getRange(), this.getRangeY(), this.getRange()))) {
            class_2680 state = this.method_10997().method_8320(pos);
            if (!matcher.test(state)) continue;
            possibleCoords.add(pos.method_10062());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (class_2338)possibleCoords.get(this.method_10997().field_9229.method_43048(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public class_3956<? extends OrechidRecipe> getRecipeType() {
        return BotaniaRecipeTypes.ORECHID_TYPE;
    }

    public Predicate<class_2680> getReplaceMatcher() {
        return state -> !OrechidManager.getMatchingRecipes(this.method_10997().method_8433(), this.getRecipeType(), state).isEmpty();
    }

    public int getCost() {
        return XplatAbstractions.INSTANCE.gogLoaded() ? 700 : 17500;
    }

    public int getDelay() {
        return XplatAbstractions.INSTANCE.gogLoaded() ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public int getRange() {
        return 5;
    }

    public int getRangeY() {
        return 3;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }
}

