/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaResult;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.BotaniaStats;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.network.serverbound.IndexStringRequestPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;
import vazkii.botania.xplat.XplatAbstractions;

public class CorporeaIndexBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaRequestor {
    public static final double RADIUS = 2.5;
    public static final int MAX_REQUEST = 65536;
    private static final Set<CorporeaIndexBlockEntity> serverIndexes = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<CorporeaIndexBlockEntity> clientIndexes = Collections.newSetFromMap(new WeakHashMap());
    private static final Map<Pattern, IRegexStacker> patterns = new LinkedHashMap<Pattern, IRegexStacker>();
    public int ticksWithCloseby = 0;
    public float closeby = 0.0f;
    public boolean hasCloseby;

    public CorporeaIndexBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.CORPOREA_INDEX, pos, state);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, CorporeaIndexBlockEntity self) {
        double x = (double)worldPosition.method_10263() + 0.5;
        double y = (double)worldPosition.method_10264() + 0.5;
        double z = (double)worldPosition.method_10260() + 0.5;
        List players = level.method_18467(class_1657.class, new class_238(x - 2.5, y - 2.5, z - 2.5, x + 2.5, y + 2.5, z + 2.5));
        self.hasCloseby = false;
        if (self.getSpark() != null) {
            for (class_1657 player : players) {
                if (!self.isInRange(player)) continue;
                self.hasCloseby = true;
                break;
            }
        }
        float step = 0.2f;
        if (self.hasCloseby) {
            ++self.ticksWithCloseby;
            if (self.closeby < 1.0f) {
                self.closeby += step;
            }
        } else if (self.closeby > 0.0f) {
            self.closeby -= step;
        }
        if (!self.method_11015()) {
            CorporeaIndexBlockEntity.addIndex(self);
        }
    }

    public static List<CorporeaIndexBlockEntity> getNearbyValidIndexes(class_1657 player) {
        ArrayList<CorporeaIndexBlockEntity> result = new ArrayList<CorporeaIndexBlockEntity>();
        for (CorporeaIndexBlockEntity index : player.method_37908().field_9236 ? clientIndexes : serverIndexes) {
            if (index.getSpark() == null || !index.isInRange(player)) continue;
            result.add(index);
        }
        return result;
    }

    public void method_11012() {
        super.method_11012();
        CorporeaIndexBlockEntity.removeIndex(this);
    }

    @Override
    public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable class_1309 entity) {
        this.doRequest(request, count, spark, entity);
    }

    private CorporeaResult doRequest(CorporeaRequestMatcher matcher, int count, CorporeaSpark spark, @Nullable class_1309 entity) {
        CorporeaResult result = CorporeaHelper.instance().requestItem(matcher, count, spark, entity, true);
        List<class_1799> stacks = result.stacks();
        spark.onItemsRequested(stacks);
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            class_1542 item = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, stack);
            this.field_11863.method_8649((class_1297)item);
        }
        return result;
    }

    private boolean isInRange(class_1657 player) {
        return player.method_37908().method_27983() == this.field_11863.method_27983() && (double)MathHelper.pointDistancePlane((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10260() + 0.5, player.method_23317(), player.method_23321()) < 2.5 && Math.abs((double)this.method_11016().method_10264() + 0.5 - player.method_23318()) < 5.0;
    }

    public static void addPattern(String pattern, IRegexStacker stacker) {
        patterns.put(Pattern.compile(pattern), stacker);
    }

    public static int i(Matcher m, int g) {
        try {
            int i = Math.abs(Integer.parseInt(m.group(g)));
            return i;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static void addIndex(CorporeaIndexBlockEntity index) {
        Set<CorporeaIndexBlockEntity> set = index.field_11863.field_9236 ? clientIndexes : serverIndexes;
        set.add(index);
    }

    private static void removeIndex(CorporeaIndexBlockEntity index) {
        Set<CorporeaIndexBlockEntity> set = index.field_11863.field_9236 ? clientIndexes : serverIndexes;
        set.remove(index);
    }

    public static void clearIndexCache() {
        clientIndexes.clear();
        serverIndexes.clear();
    }

    public void performPlayerRequest(class_3222 player, CorporeaRequestMatcher request, int count) {
        if (!XplatAbstractions.INSTANCE.fireCorporeaIndexRequestEvent(player, request, count, this.getSpark())) {
            CorporeaResult res = this.doRequest(request, count, this.getSpark(), (class_1309)player);
            player.method_43496((class_2561)class_2561.method_43469((String)"botaniamisc.requestMsg", (Object[])new Object[]{count, request.getRequestName(), res.matchedCount(), res.extractedCount()}).method_27692(class_124.field_1076));
            player.method_7339(BotaniaStats.CORPOREA_ITEMS_REQUESTED, res.extractedCount());
            CorporeaRequestTrigger.INSTANCE.trigger(player, player.method_51469(), this.method_11016(), res.extractedCount());
        }
    }

    public static void onChatMessage(class_3222 player, String message) {
        if (player.method_7325()) {
            return;
        }
        List<CorporeaIndexBlockEntity> nearbyIndexes = CorporeaIndexBlockEntity.getNearbyValidIndexes((class_1657)player);
        if (!nearbyIndexes.isEmpty()) {
            String msg = message.toLowerCase(Locale.ROOT).trim();
            for (CorporeaIndexBlockEntity index : nearbyIndexes) {
                class_1799 stack;
                String name = "";
                int count = 0;
                for (Pattern pattern : patterns.keySet()) {
                    Matcher matcher = pattern.matcher(msg);
                    if (!matcher.matches()) continue;
                    IRegexStacker stacker = patterns.get(pattern);
                    count = Math.min(65536, stacker.getCount(matcher));
                    name = stacker.getName(matcher).toLowerCase(Locale.ROOT).trim();
                }
                if (name.equals("this") && !(stack = player.method_6047()).method_7960()) {
                    name = stack.method_7964().getString().toLowerCase(Locale.ROOT).trim();
                }
                index.performPlayerRequest(player, CorporeaHelper.instance().createMatcher(name), count);
            }
        }
    }

    static {
        CorporeaIndexBlockEntity.addPattern("(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("a??n?? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?? stacks?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?stack (?:(?:and)|(?:\\+)) (\\d+)(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 + CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?? stacks? (?:(?:and)|(?:\\+)) (\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * CorporeaIndexBlockEntity.i(m, 1) + CorporeaIndexBlockEntity.i(m, 2);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(3);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?half (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 32;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?quarter (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 16;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?dozen(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?? dozens?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12 * CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:all|every) (?:(?:of|the) )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 65536;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:the )?answer to life,? the universe and everything (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 42;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:a )?nice (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(\\d+)x?? nices?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69 * CorporeaIndexBlockEntity.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        CorporeaIndexBlockEntity.addPattern("(?:count|show|display|tell) (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 0;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
    }

    public static interface IRegexStacker {
        public int getCount(Matcher var1);

        public String getName(Matcher var1);
    }

    public static class ClientHandler {
        public static boolean onChat(class_1657 player, String message) {
            if (!CorporeaIndexBlockEntity.getNearbyValidIndexes(player).isEmpty()) {
                ClientXplatAbstractions.INSTANCE.sendToServer(new IndexStringRequestPacket(message));
                return true;
            }
            return false;
        }
    }
}

