/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.TerrestrialAgglomerationDrawable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TerrestrialAgglomerationRecipeCategory
implements IRecipeCategory<TerrestrialAgglomerationRecipe> {
    public static final RecipeType<TerrestrialAgglomerationRecipe> TYPE = RecipeType.create((String)"botania", (String)"terra_plate", TerrestrialAgglomerationRecipe.class);
    private final class_2561 localizedName;
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IDrawable terraPlate;

    public TerrestrialAgglomerationRecipeCategory(IGuiHelper guiHelper) {
        class_2960 location = ResourceLocationHelper.prefix("textures/gui/terrasteel_jei_overlay.png");
        this.background = guiHelper.createBlankDrawable(114, 131);
        this.overlay = guiHelper.createDrawable(location, 42, 29, 64, 64);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)BotaniaBlocks.terraPlate));
        this.localizedName = class_2561.method_43471((String)"botania.nei.terraPlate");
        IDrawable livingrock = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)BotaniaBlocks.livingrock));
        this.terraPlate = new TerrestrialAgglomerationDrawable(livingrock, livingrock, guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)class_2246.field_10441)));
    }

    @NotNull
    public RecipeType<TerrestrialAgglomerationRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull TerrestrialAgglomerationRecipe recipe, @NotNull IRecipeSlotsView view, @NotNull class_332 gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 25, 14);
        HUDHandler.renderManaBar(gui, 6, 126, 255, 0.75f, recipe.getMana(), 100000);
        this.terraPlate.draw(gui, 35, 92);
        RenderSystem.disableBlend();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull TerrestrialAgglomerationRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 48, 37).addItemStack(recipe.method_8110((class_5455)class_5455.field_40585));
        double angleBetweenEach = 360.0 / (double)recipe.method_8117().size();
        class_241 point = new class_241(48.0f, 5.0f);
        class_241 center = new class_241(48.0f, 37.0f);
        for (class_1856 ingr : recipe.method_8117()) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)point.field_1343, (int)point.field_1342).addIngredients(ingr);
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 48, 92).addItemStack(new class_1799((class_1935)BotaniaBlocks.terraPlate));
    }
}

