/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaCrystalCubeBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.AssemblyHaloItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.WorldshaperssSextantItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;
import vazkii.botania.common.item.equipment.bauble.RingOfDexterousMotionItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.ClientXplatAbstractions;
import vazkii.botania.xplat.XplatAbstractions;

public final class HUDHandler {
    public static final class_2960 manaBar = new class_2960("botania:textures/gui/mana_hud.png");
    private static boolean didOptifineDetection = false;

    private HUDHandler() {
    }

    public static void tryOptifineWarning() {
        if (!didOptifineDetection) {
            try {
                Class.forName("optifine.Installer");
                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"botaniamisc.optifine_warning"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            didOptifineDetection = true;
        }
    }

    public static void onDrawScreenPost(class_332 gui, float partialTicks) {
        class_3966 result;
        WandHUD hud;
        class_239 pos;
        class_4587 ms = gui.method_51448();
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842) {
            return;
        }
        class_3695 profiler = mc.method_16011();
        class_1799 main = mc.field_1724.method_6047();
        class_1799 offhand = mc.field_1724.method_6079();
        profiler.method_15396("botania-hud");
        if (class_310.method_1551().field_1761.method_2908()) {
            class_1799 dodgeRing;
            class_1799 tiara = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, (class_1309)mc.field_1724);
            if (!tiara.method_7960()) {
                profiler.method_15396("flugelTiara");
                FlugelTiaraItem.ClientLogic.renderHUD(gui, (class_1657)mc.field_1724, tiara);
                profiler.method_15407();
            }
            if (!(dodgeRing = EquipmentHandler.findOrEmpty(BotaniaItems.dodgeRing, (class_1309)mc.field_1724)).method_7960()) {
                profiler.method_15396("dodgeRing");
                RingOfDexterousMotionItem.ClientLogic.renderHUD(gui, (class_1657)mc.field_1724, dodgeRing, partialTicks);
                profiler.method_15407();
            }
        }
        if ((pos = mc.field_1765) instanceof class_3965) {
            class_3965 result2 = (class_3965)pos;
            class_2338 bpos = result2.method_17777();
            class_2680 state = mc.field_1687.method_8320(bpos);
            class_2586 tile = mc.field_1687.method_8321(bpos);
            if (PlayerHelper.hasAnyHeldItem((class_1657)mc.field_1724)) {
                boolean alternateRecipeHudPosition = false;
                if (PlayerHelper.hasHeldItemClass((class_1657)mc.field_1724, WandOfTheForestItem.class)) {
                    HUDHandler.tryOptifineWarning();
                    WandHUD hud2 = ClientXplatAbstractions.INSTANCE.findWandHud((class_1937)mc.field_1687, bpos, state, tile);
                    if (hud2 != null) {
                        alternateRecipeHudPosition = true;
                        profiler.method_15396("wandItem");
                        hud2.renderHUD(gui, mc);
                        profiler.method_15407();
                    }
                }
                if (tile instanceof ManaPoolBlockEntity) {
                    ManaPoolBlockEntity pool = (ManaPoolBlockEntity)tile;
                    if (!mc.field_1724.method_6047().method_7960()) {
                        HUDHandler.renderPoolRecipeHUD(gui, pool, mc.field_1724.method_6047(), alternateRecipeHudPosition);
                    }
                }
            }
            if (!PlayerHelper.hasHeldItem((class_1657)mc.field_1724, BotaniaItems.lexicon)) {
                if (tile instanceof PetalApothecaryBlockEntity) {
                    PetalApothecaryBlockEntity altar = (PetalApothecaryBlockEntity)tile;
                    PetalApothecaryBlockEntity.Hud.render(altar, gui, mc);
                } else if (tile instanceof RunicAltarBlockEntity) {
                    RunicAltarBlockEntity runeAltar = (RunicAltarBlockEntity)tile;
                    RunicAltarBlockEntity.Hud.render(runeAltar, gui, mc);
                } else if (tile instanceof CorporeaCrystalCubeBlockEntity) {
                    CorporeaCrystalCubeBlockEntity cube = (CorporeaCrystalCubeBlockEntity)tile;
                    CorporeaCrystalCubeBlockEntity.Hud.render(gui, cube);
                }
            }
        } else if (pos instanceof class_3966 && (hud = ClientXplatAbstractions.INSTANCE.findWandHud((result = (class_3966)pos).method_17782())) != null && PlayerHelper.hasHeldItemClass((class_1657)mc.field_1724, WandOfTheForestItem.class)) {
            profiler.method_15396("wandItemEntityHud");
            hud.renderHUD(gui, mc);
            profiler.method_15407();
        }
        if (!CorporeaIndexBlockEntity.getNearbyValidIndexes((class_1657)mc.field_1724).isEmpty() && mc.field_1755 instanceof class_408) {
            profiler.method_15396("nearIndex");
            HUDHandler.renderNearIndexDisplay(gui);
            profiler.method_15407();
        }
        if (!main.method_7960() && main.method_7909() instanceof AssemblyHaloItem) {
            profiler.method_15396("craftingHalo_main");
            AssemblyHaloItem.Rendering.renderHUD(gui, (class_1657)mc.field_1724, main);
            profiler.method_15407();
        } else if (!offhand.method_7960() && offhand.method_7909() instanceof AssemblyHaloItem) {
            profiler.method_15396("craftingHalo_off");
            AssemblyHaloItem.Rendering.renderHUD(gui, (class_1657)mc.field_1724, offhand);
            profiler.method_15407();
        }
        if (!main.method_7960() && main.method_7909() instanceof WorldshaperssSextantItem) {
            profiler.method_15396("sextant");
            WorldshaperssSextantItem.Hud.render(gui, (class_1657)mc.field_1724, main);
            profiler.method_15407();
        }
        if (ManaseerMonocleItem.hasMonocle((class_1309)mc.field_1724)) {
            profiler.method_15396("monocle");
            ManaseerMonocleItem.Hud.render(gui, (class_1657)mc.field_1724);
            profiler.method_15407();
        }
        profiler.method_15396("manaBar");
        class_746 player = mc.field_1724;
        if (!player.method_7325()) {
            int totalMana = 0;
            int totalMaxMana = 0;
            boolean anyRequest = false;
            class_1661 mainInv = player.method_31548();
            class_1263 accInv = BotaniaAPI.instance().getAccessoriesInventory((class_1657)player);
            int invSize = mainInv.method_5439();
            int size = invSize + accInv.method_5439();
            for (int i = 0; i < size; ++i) {
                boolean useAccessories = i >= invSize;
                Object inv = useAccessories ? accInv : mainInv;
                class_1799 stack = inv.method_5438(i - (useAccessories ? invSize : 0));
                if (stack.method_7960()) continue;
                anyRequest = anyRequest || stack.method_31573(BotaniaTags.Items.MANA_USING_ITEMS);
            }
            List<class_1799> items = ManaItemHandler.instance().getManaItems((class_1657)player);
            List<class_1799> acc = ManaItemHandler.instance().getManaAccesories((class_1657)player);
            for (class_1799 stack : Iterables.concat(items, acc)) {
                ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                if (manaItem.isNoExport()) continue;
                totalMana += manaItem.getMana();
                totalMaxMana += manaItem.getMaxMana();
            }
            if (anyRequest) {
                HUDHandler.renderManaInvBar(gui, totalMana, totalMaxMana);
            }
        }
        profiler.method_15405("itemsRemaining");
        ItemsRemainingRenderHandler.render(gui, partialTicks);
        profiler.method_15407();
        profiler.method_15407();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderManaInvBar(class_332 gui, int totalMana, int totalMaxMana) {
        class_310 mc = class_310.method_1551();
        int width = 182;
        int x = mc.method_22683().method_4486() / 2 - width / 2;
        int y = mc.method_22683().method_4502() - BotaniaConfig.client().manaBarHeight();
        width = totalMaxMana == 0 ? 0 : (int)((double)width * ((double)totalMana / (double)totalMaxMana));
        if (width == 0) {
            if (totalMana > 0) {
                width = 1;
            } else {
                return;
            }
        }
        int color = class_3532.method_15369((float)0.55f, (float)((float)Math.min(1.0, Math.sin((double)class_156.method_658() / 200.0) * 0.5 + 1.0)), (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)(1.0f - (float)r / 255.0f));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, 0, 251, width, 5);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderPoolRecipeHUD(class_332 gui, ManaPoolBlockEntity tile, class_1799 stack, boolean alternateRecipeHudPosition) {
        class_310 mc = class_310.method_1551();
        class_3695 profiler = mc.method_16011();
        profiler.method_15396("poolRecipe");
        ManaInfusionRecipe recipe = tile.getMatchingRecipe(stack, tile.method_10997().method_8320(tile.method_11016().method_10074()));
        if (recipe != null) {
            int x = mc.method_22683().method_4486() / 2 - 11;
            int y = mc.method_22683().method_4502() / 2 + (alternateRecipeHudPosition ? -25 : 10);
            int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
            int v = mc.field_1724.method_5477().getString().equals("haighyorkie") && mc.field_1724.method_5715() ? 23 : 8;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, u, v, 22, 15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.method_51427(stack, x - 20, y);
            class_1799 result = recipe.method_8110(mc.field_1687.method_30349());
            gui.method_51427(result, x + 26, y);
            gui.method_51431(mc.field_1772, result, x + 26, y);
            RenderSystem.disableBlend();
        }
        profiler.method_15407();
    }

    private static void renderNearIndexDisplay(class_332 gui) {
        class_310 mc = class_310.method_1551();
        String txt0 = class_1074.method_4662((String)"botaniamisc.nearIndex0", (Object[])new Object[0]);
        String txt1 = class_124.field_1080 + class_1074.method_4662((String)"botaniamisc.nearIndex1", (Object[])new Object[0]);
        String txt2 = class_124.field_1080 + class_1074.method_4662((String)"botaniamisc.nearIndex2", (Object[])new Object[0]);
        int l = Math.max(mc.field_1772.method_1727(txt0), Math.max(mc.field_1772.method_1727(txt1), mc.field_1772.method_1727(txt2))) + 20;
        int x = mc.method_22683().method_4486() - l - 20;
        int y = mc.method_22683().method_4502() - 60;
        RenderHelper.renderHUDBox(gui, x - 4, y - 4, x + l + 4, y + 35);
        gui.method_51427(new class_1799((class_1935)BotaniaBlocks.corporeaIndex), x, y + 10);
        gui.method_25303(mc.field_1772, txt0, x + 20, y, 0xFFFFFF);
        gui.method_25303(mc.field_1772, txt1, x + 20, y + 14, 0xFFFFFF);
        gui.method_25303(mc.field_1772, txt2, x + 20, y + 24, 0xFFFFFF);
    }

    public static void drawSimpleManaHUD(class_332 gui, int color, int mana, int maxMana, String name) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        class_310 mc = class_310.method_1551();
        int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(name) / 2;
        int y = mc.method_22683().method_4502() / 2 + 10;
        gui.method_25303(mc.field_1772, name, x, y, color);
        x = mc.method_22683().method_4486() / 2 - 51;
        HUDHandler.renderManaBar(gui, x, y += 10, color, 1.0f, mana, maxMana);
        RenderSystem.disableBlend();
    }

    public static void drawComplexManaHUD(int color, class_332 gui, int mana, int maxMana, String name, class_1799 bindDisplay, boolean properlyBound) {
        class_4587 ms = gui.method_51448();
        HUDHandler.drawSimpleManaHUD(gui, color, mana, maxMana, name);
        class_310 mc = class_310.method_1551();
        int x = mc.method_22683().method_4486() / 2 + 55;
        int y = mc.method_22683().method_4502() / 2 + 12;
        gui.method_51427(bindDisplay, x, y);
        RenderSystem.disableDepthTest();
        ms.method_22903();
        ms.method_46416(0.0f, 0.0f, 200.0f);
        if (properlyBound) {
            gui.method_25303(mc.field_1772, "\u2714", x + 10, y + 9, 19456);
            gui.method_25303(mc.field_1772, "\u2714", x + 10, y + 8, 774669);
        } else {
            gui.method_25303(mc.field_1772, "\u2718", x + 10, y + 9, 0x4C0000);
            gui.method_25303(mc.field_1772, "\u2718", x + 10, y + 8, 13764621);
        }
        ms.method_22909();
        RenderSystem.enableDepthTest();
    }

    public static void renderManaBar(class_332 gui, int x, int y, int color, float alpha, int mana, int maxMana) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(gui, manaBar, x + 1, y + 1, 0, 5, 100, 3);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x + 1, y + 1, 0, 5, Math.min(100, manaPercentage), 3);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

