/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.mixinsupport;

import com.google.common.collect.Maps;
import dev.emi.emi.mixinsupport.annotation.Transform;
import java.util.HashMap;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.util.Annotations;

public class EmiMixinTransformation {
    private static int VISIBILITY_MASK = -8;

    public static void relinkTransforms(ClassNode clazz) {
        HashMap changedMethods = Maps.newHashMap();
        for (MethodNode method : clazz.methods) {
            String target = method.name + method.desc;
            if (!EmiMixinTransformation.applyTransform(method)) continue;
            changedMethods.put(target, method);
        }
        HashMap changedFields = Maps.newHashMap();
        for (FieldNode field : clazz.fields) {
            String target = field.name + ":" + field.desc;
            if (!EmiMixinTransformation.applyTransform(field)) continue;
            changedFields.put(target, field);
        }
        for (MethodNode method : clazz.methods) {
            for (AbstractInsnNode node : method.instructions) {
                MethodNode changed;
                String target;
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode min = (MethodInsnNode)node;
                    target = min.name + min.desc;
                    if (!changedMethods.containsKey(target)) continue;
                    changed = (MethodNode)changedMethods.get(target);
                    min.name = changed.name;
                    min.desc = changed.desc;
                    continue;
                }
                if (!(node instanceof FieldInsnNode)) continue;
                FieldInsnNode fin = (FieldInsnNode)node;
                target = fin.name + ":" + fin.desc;
                if (!changedFields.containsKey(target)) continue;
                changed = (FieldNode)changedFields.get(target);
                fin.name = changed.name;
                fin.desc = changed.desc;
            }
        }
    }

    public static void applyTransform(ClassNode clazz) {
        AnnotationNode transform = Annotations.getInvisible((ClassNode)clazz, Transform.class);
        if (transform != null) {
            String visibility = (String)Annotations.getValue((AnnotationNode)transform, (String)"visibility", (Object)"");
            int flags = (Integer)Annotations.getValue((AnnotationNode)transform, (String)"flags", (Object)0);
            clazz.access = EmiMixinTransformation.mutateAccess(clazz.access, visibility);
            clazz.access |= flags;
        }
    }

    public static boolean applyTransform(MethodNode method) {
        AnnotationNode transform = Annotations.getInvisible((MethodNode)method, Transform.class);
        if (transform != null) {
            String name = (String)Annotations.getValue((AnnotationNode)transform, (String)"name", (Object)"");
            String desc = (String)Annotations.getValue((AnnotationNode)transform, (String)"desc", (Object)"");
            String visibility = (String)Annotations.getValue((AnnotationNode)transform, (String)"visibility", (Object)"");
            int flags = (Integer)Annotations.getValue((AnnotationNode)transform, (String)"flags", (Object)0);
            if (!name.isEmpty()) {
                method.name = name;
            }
            if (!desc.isEmpty()) {
                method.desc = desc;
            }
            method.access = EmiMixinTransformation.mutateAccess(method.access, visibility);
            method.access |= flags;
            return true;
        }
        return false;
    }

    public static boolean applyTransform(FieldNode field) {
        AnnotationNode transform = Annotations.getInvisible((FieldNode)field, Transform.class);
        if (transform != null) {
            String name = (String)Annotations.getValue((AnnotationNode)transform, (String)"name", (Object)"");
            String desc = (String)Annotations.getValue((AnnotationNode)transform, (String)"desc", (Object)"");
            String visibility = (String)Annotations.getValue((AnnotationNode)transform, (String)"visibility", (Object)"");
            int flags = (Integer)Annotations.getValue((AnnotationNode)transform, (String)"flags", (Object)0);
            if (!name.isEmpty()) {
                field.name = name;
            }
            if (!desc.isEmpty()) {
                field.desc = desc;
            }
            field.access = EmiMixinTransformation.mutateAccess(field.access, visibility);
            field.access |= flags;
            return true;
        }
        return false;
    }

    private static int mutateAccess(int access, String visibility) {
        return switch (visibility) {
            case "PRIVATE" -> access & VISIBILITY_MASK | 2;
            case "PROTECTED" -> access & VISIBILITY_MASK | 4;
            case "PUBLIC" -> access & VISIBILITY_MASK | 1;
            case "PACKAGE" -> access & VISIBILITY_MASK;
            default -> access;
        };
    }
}

