/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi.impl;

import com.google.common.collect.Maps;
import dev.emi.emi.jemi.impl.JemiIngredientAcceptor;
import dev.emi.emi.jemi.impl.JemiRecipeSlot;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class JemiRecipeSlotBuilder
implements IRecipeSlotBuilder {
    public final JemiIngredientAcceptor acceptor;
    public final int x;
    public final int y;
    public Optional<String> name = Optional.empty();
    public IRecipeSlotTooltipCallback tooltipCallback;
    public JemiRecipeSlot.OffsetDrawable background;
    public JemiRecipeSlot.OffsetDrawable overlay;
    public Map<IIngredientType<?>, JemiRecipeSlot.IngredientRenderer<?>> renderers;
    public JemiRecipeSlot.TankInfo tankInfo;

    public JemiRecipeSlotBuilder(RecipeIngredientRole role, int x, int y) {
        this.acceptor = new JemiIngredientAcceptor(role);
        this.x = x;
        this.y = y;
    }

    public <I> IRecipeSlotBuilder addIngredients(IIngredientType<I> ingredientType, List<@Nullable I> ingredients) {
        this.acceptor.addIngredients((IIngredientType)ingredientType, (List)ingredients);
        return this;
    }

    public <I> IRecipeSlotBuilder addIngredient(IIngredientType<I> ingredientType, I ingredient) {
        this.acceptor.addIngredient((IIngredientType)ingredientType, (Object)ingredient);
        return this;
    }

    public IRecipeSlotBuilder addIngredientsUnsafe(List<?> ingredients) {
        this.acceptor.addIngredientsUnsafe((List)ingredients);
        return this;
    }

    public IRecipeSlotBuilder addFluidStack(class_3611 fluid, long amount) {
        this.acceptor.addFluidStack(fluid, amount);
        return this;
    }

    public IRecipeSlotBuilder addFluidStack(class_3611 fluid, long amount, class_2487 tag) {
        this.acceptor.addFluidStack(fluid, amount, tag);
        return this;
    }

    public IRecipeSlotBuilder addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
        return this;
    }

    public IRecipeSlotBuilder setSlotName(String slotName) {
        this.name = Optional.ofNullable(slotName);
        return this;
    }

    public IRecipeSlotBuilder setBackground(IDrawable background, int xOffset, int yOffset) {
        this.background = new JemiRecipeSlot.OffsetDrawable(background, xOffset, yOffset);
        return this;
    }

    public IRecipeSlotBuilder setOverlay(IDrawable overlay, int xOffset, int yOffset) {
        this.overlay = new JemiRecipeSlot.OffsetDrawable(overlay, xOffset, yOffset);
        return this;
    }

    public IRecipeSlotBuilder setFluidRenderer(long capacity, boolean showCapacity, int width, int height) {
        this.tankInfo = new JemiRecipeSlot.TankInfo(width, height, capacity, showCapacity);
        return this;
    }

    public <T> IRecipeSlotBuilder setCustomRenderer(IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        if (this.renderers == null) {
            this.renderers = Maps.newHashMap();
        }
        this.renderers.put(ingredientType, new JemiRecipeSlot.IngredientRenderer<T>(ingredientType, ingredientRenderer));
        return this;
    }
}

