/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.platform.EmiAgnos;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FluidEmiStack
extends EmiStack {
    private final class_3611 fluid;
    private final class_2487 nbt;

    public FluidEmiStack(class_3611 fluid) {
        this(fluid, null);
    }

    public FluidEmiStack(class_3611 fluid, @Nullable class_2487 nbt) {
        this(fluid, nbt, 0L);
    }

    public FluidEmiStack(class_3611 fluid, @Nullable class_2487 nbt, long amount) {
        this.fluid = fluid;
        this.nbt = nbt;
        this.amount = amount;
    }

    @Override
    public EmiStack copy() {
        FluidEmiStack e = new FluidEmiStack(this.fluid, this.nbt, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public class_2487 getNbt() {
        return this.nbt;
    }

    @Override
    public Object getKey() {
        return this.fluid;
    }

    @Override
    public class_2960 getId() {
        return EmiPort.getFluidRegistry().method_10221((Object)this.fluid);
    }

    @Override
    public void render(class_332 draw, int x, int y, float delta, int flags) {
        if ((flags & 1) != 0) {
            EmiAgnos.renderFluid(this, draw.method_51448(), x, y, delta);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, draw, x, y);
        }
    }

    @Override
    public List<class_2561> getTooltipText() {
        return EmiAgnos.getFluidTooltip(this.fluid, this.nbt);
    }

    @Override
    public List<class_5684> getTooltip() {
        List<class_5684> list = this.getTooltipText().stream().map(EmiPort::ordered).map(class_5684::method_32662).collect(Collectors.toList());
        if (this.amount > 1L) {
            list.add(EmiTooltipComponents.getAmount(this));
        }
        String namespace = EmiPort.getFluidRegistry().method_10221((Object)this.fluid).method_12836();
        if (EmiConfig.appendModId) {
            String mod = EmiUtil.getModName(namespace);
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal(mod, class_124.field_1078, class_124.field_1056))));
        }
        list.addAll(super.getTooltip());
        return list;
    }

    @Override
    public class_2561 getName() {
        return EmiAgnos.getFluidName(this.fluid, this.nbt);
    }

    static class FluidEntry {
        FluidEntry() {
        }
    }
}

