/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IRayCastVectorProvider;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.ComponentHandler;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.RayCaster;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.mixin.PlayerTabOverlayAccess;
import mcp.mobius.waila.pick.PickerAccessor;
import mcp.mobius.waila.pick.PickerResults;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_746;

public class TooltipHandler {
    private static final ConfigTooltipRendererState STATE = new ConfigTooltipRendererState();
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final class_2561 SNEAK_DETAIL = class_2561.method_43471((String)"tooltip.waila.sneak_for_details").method_27692(class_124.field_1056);

    public static void tick() {
        TooltipHandler.STATE.render = false;
        class_310 client = class_310.method_1551();
        WailaConfig.General config = Waila.CONFIG.get().getGeneral();
        if (client.field_1690.field_1842) {
            return;
        }
        if (client.field_1755 != null && !(client.field_1755 instanceof class_408)) {
            return;
        }
        if (client.field_1687 == null || !config.isDisplayTooltip()) {
            return;
        }
        if (config.getDisplayMode() == IWailaConfig.General.DisplayMode.HOLD_KEY && !WailaClient.keyShowOverlay.method_1434()) {
            return;
        }
        if (config.isHideFromPlayerList() && ((PlayerTabOverlayAccess)client.field_1705.method_1750()).wthit_isVisible()) {
            return;
        }
        if (config.isHideFromDebug() && client.field_1690.field_1866) {
            return;
        }
        if (client.field_1761 == null) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1297 camera = client.field_1719;
        if (camera == null) {
            return;
        }
        float frameTime = client.method_1488();
        float pickRange = client.field_1761.method_2904();
        PickerResults results = PickerResults.get();
        class_243 castOrigin = null;
        class_243 castDirection = null;
        IObjectPicker picker = Registrar.INSTANCE.picker;
        if (picker != null) {
            castOrigin = camera.method_5836(frameTime);
            castDirection = camera.method_5828(frameTime);
            picker.pick(PickerAccessor.of(client, camera, pickRange, frameTime), results, PluginConfig.CLIENT);
        } else {
            for (IInstanceRegistry.Entry<IRayCastVectorProvider> entry : Registrar.INSTANCE.raycastVectorProviders.get(Object.class)) {
                IRayCastVectorProvider provider = entry.instance();
                if (!provider.isEnabled(PluginConfig.CLIENT)) continue;
                castOrigin = provider.getOrigin(frameTime);
                castDirection = provider.getDirection(frameTime);
                RayCaster.cast((class_1937)client.field_1687, camera, castOrigin, castDirection, pickRange, results);
                break;
            }
        }
        if (castOrigin == null) {
            return;
        }
        for (class_239 target : results) {
            ClientAccessor accessor = ClientAccessor.INSTANCE;
            accessor.set((class_1937)client.field_1687, (class_1657)player, target, client.field_1719, castOrigin, castDirection, pickRange, client.method_1488());
            TooltipRenderer.beginBuild(STATE);
            if (target.method_17783() == class_239.class_240.field_1332) {
                class_2680 state;
                Object blockEntity;
                class_2248 block = accessor.getBlock();
                if (!(block instanceof class_2404) ? !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK) : !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID)) continue;
                if (IBlacklistConfig.get().contains(block) || (blockEntity = accessor.getBlockEntity()) != null && IBlacklistConfig.get().contains((class_2586)blockEntity) || (state = ComponentHandler.getOverrideBlock(target)) == IBlockComponentProvider.EMPTY_BLOCK_STATE) continue;
                accessor.setState(state);
                ComponentHandler.requestBlockData(accessor);
                TOOLTIP.clear();
                ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.HEAD);
                TooltipRenderer.add(TOOLTIP);
                TOOLTIP.clear();
                ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.BODY);
                if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.method_5715()) {
                    if (!config.isHideShiftText()) {
                        TooltipRenderer.add(new Line(null).with(SNEAK_DETAIL));
                    }
                } else {
                    TooltipRenderer.add(TOOLTIP);
                }
                TOOLTIP.clear();
                ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.TAIL);
            } else if (target.method_17783() == class_239.class_240.field_1331) {
                class_1297 targetEnt;
                Object actualEntity;
                if (!PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY) || (actualEntity = accessor.getEntity()) == null || IBlacklistConfig.get().contains((class_1297)actualEntity) || (targetEnt = ComponentHandler.getOverrideEntity(target)) == IEntityComponentProvider.EMPTY_ENTITY) continue;
                accessor.setEntity(targetEnt);
                if (targetEnt == null) continue;
                ComponentHandler.requestEntityData(targetEnt, accessor);
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.HEAD);
                TooltipRenderer.add(TOOLTIP);
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.BODY);
                if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.method_5715()) {
                    if (!config.isHideShiftText()) {
                        TooltipRenderer.add(new Line(null).with(SNEAK_DETAIL));
                    }
                } else {
                    TooltipRenderer.add(TOOLTIP);
                }
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.TAIL);
            }
            TooltipRenderer.add(TOOLTIP);
            if (PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ICON)) {
                TooltipRenderer.setIcon(ComponentHandler.getIcon(target));
            }
            TooltipHandler.STATE.render = true;
            TooltipRenderer.endBuild();
            break;
        }
    }

    private static class ConfigTooltipRendererState
    implements TooltipRenderer.State {
        private boolean render;

        private ConfigTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return this.render;
        }

        @Override
        public boolean fireEvent() {
            return true;
        }

        private WailaConfig.Overlay getOverlay() {
            return Waila.CONFIG.get().getOverlay();
        }

        @Override
        public int getFps() {
            return this.getOverlay().getFps();
        }

        @Override
        public float getScale() {
            return this.getOverlay().getScale();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return this.getOverlay().getPosition().getAnchor().getX();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return this.getOverlay().getPosition().getAnchor().getY();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return this.getOverlay().getPosition().getAlign().getX();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return this.getOverlay().getPosition().getAlign().getY();
        }

        @Override
        public int getX() {
            return this.getOverlay().getPosition().getX();
        }

        @Override
        public int getY() {
            return this.getOverlay().getPosition().getY();
        }

        @Override
        public boolean bossBarsOverlap() {
            return this.getOverlay().getPosition().isBossBarsOverlap();
        }

        @Override
        public ITheme getTheme() {
            return this.getOverlay().getColor().getTheme();
        }

        @Override
        public int getBackgroundAlpha() {
            return this.getOverlay().getColor().getBackgroundAlpha();
        }

        @Override
        public boolean enableTextToSpeech() {
            return Waila.CONFIG.get().getGeneral().isEnableTextToSpeech();
        }
    }
}

