/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.datagen;

import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7655;
import net.minecraft.class_7877;
import org.betterx.bclib.BCLib;
import org.jetbrains.annotations.Nullable;

public abstract class RegistrySupplier {
    private static final int MAX_PERMITS = 2000;
    private final Semaphore BOOTSTRAP_LOCK = new Semaphore(2000);
    public final Semaphore MAIN_LOCK = new Semaphore(1);
    final List<RegistryInfo<?>> allRegistries;
    @Nullable
    List<String> defaultModIDs;

    protected RegistrySupplier(@Nullable List<String> defaultModIDs) {
        this.defaultModIDs = defaultModIDs;
        this.allRegistries = this.initializeRegistryList(defaultModIDs);
        try {
            this.BOOTSTRAP_LOCK.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract List<RegistryInfo<?>> initializeRegistryList(@Nullable List<String> var1);

    public void bootstrapRegistries(class_7877 registryBuilder) {
        for (RegistryInfo<?> nfo : this.allRegistries) {
            nfo.add(registryBuilder, this.BOOTSTRAP_LOCK);
        }
        this.BOOTSTRAP_LOCK.release();
    }

    void acquireLock() {
        try {
            this.BOOTSTRAP_LOCK.acquire(2000);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void releaseLock() {
        this.BOOTSTRAP_LOCK.release(2000);
    }

    public final class RegistryInfo<T> {
        public static final List<String> UNFILTERED = null;
        public final class_7655.class_7657<T> data;
        public final List<String> modIDs;
        public final class_7877.class_7882<T> registryBootstrap;

        public RegistryInfo(class_7655.class_7657<T> data, List<String> modIDs, class_7877.class_7882<T> registryBootstrap) {
            this.data = data;
            this.modIDs = modIDs;
            this.registryBootstrap = registryBootstrap;
        }

        public RegistryInfo(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, class_7877.class_7882<T> registryBootstrap) {
            this(new class_7655.class_7657(key, elementCodec), this$0.defaultModIDs, registryBootstrap);
        }

        public RegistryInfo(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, class_7877.class_7882<T> registryBootstrap, String ... modIDs) {
            this(new class_7655.class_7657(key, elementCodec), List.of(modIDs), registryBootstrap);
        }

        public RegistryInfo(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, class_7877.class_7882<T> registryBootstrap, List<String> modIDs) {
            this(new class_7655.class_7657(key, elementCodec), modIDs, registryBootstrap);
        }

        public RegistryInfo(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec) {
            this(new class_7655.class_7657(key, elementCodec), this$0.defaultModIDs, null);
        }

        public RegistryInfo(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, String ... modIDs) {
            this(new class_7655.class_7657(key, elementCodec), List.of(modIDs), null);
        }

        public RegistryInfo(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, List<String> modIDs) {
            this(new class_7655.class_7657(key, elementCodec), modIDs, null);
        }

        public class_5321<? extends class_2378<T>> key() {
            return this.data.comp_985();
        }

        public Codec<T> elementCodec() {
            return this.data.comp_986();
        }

        List<class_6880<T>> allElements(class_7225.class_7874 registryAccess) {
            class_7225.class_7226 registry = registryAccess.method_46762(this.key());
            return registry.method_46754().filter(k -> this.modIDs == null || this.modIDs.contains(k.method_29177().method_12836())).map(k -> (class_6880)registry.method_46746(k).orElseThrow()).toList();
        }

        private void add(class_7877 registryBuilder, Semaphore LOCK_BOOSTRAP) {
            try {
                LOCK_BOOSTRAP.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            BCLib.LOGGER.info("Adding:" + this.key());
            registryBuilder.method_46777(this.key(), ctx -> {
                if (this.registryBootstrap != null) {
                    this.registryBootstrap.run(ctx);
                }
                LOCK_BOOSTRAP.release();
            });
        }

        public class_7655.class_7657<T> data() {
            return this.data;
        }

        public List<String> modIDs() {
            return this.modIDs;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RegistryInfo that = (RegistryInfo)obj;
            return Objects.equals(this.data, that.data) && Objects.equals(this.modIDs, that.modIDs);
        }

        public int hashCode() {
            return Objects.hash(this.data, this.modIDs);
        }

        public String toString() {
            return "RegistryInfo[data=" + this.data + ", modIDs=" + this.modIDs + "]";
        }
    }

    public class InfoList
    extends LinkedList<RegistryInfo<?>> {
        public <T> void add(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec) {
            this.add(new RegistryInfo<T>(key, elementCodec));
        }

        public <T> void add(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, String ... modIDs) {
            this.add(new RegistryInfo<T>(key, elementCodec, modIDs));
        }

        public <T> void add(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, List<String> modIDs) {
            this.add(new RegistryInfo<T>(key, elementCodec, modIDs));
        }

        public <T> void addUnfiltered(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec) {
            this.add(new RegistryInfo<T>(key, elementCodec, RegistryInfo.UNFILTERED));
        }

        public <T> void add(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, class_7877.class_7882<T> registryBootstrap) {
            this.add(new RegistryInfo<T>(key, elementCodec, registryBootstrap));
        }

        public <T> void add(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, class_7877.class_7882<T> registryBootstrap, String ... modIDs) {
            this.add(new RegistryInfo<T>(key, elementCodec, registryBootstrap, modIDs));
        }

        public <T> void add(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, class_7877.class_7882<T> registryBootstrap, List<String> modIDs) {
            this.add(new RegistryInfo<T>(key, elementCodec, registryBootstrap, modIDs));
        }

        public <T> void addUnfiltered(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, class_7877.class_7882<T> registryBootstrap) {
            this.add(new RegistryInfo<T>(key, elementCodec, registryBootstrap, RegistryInfo.UNFILTERED));
        }

        public <T> void addBootstrapOnly(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, class_7877.class_7882<T> registryBootstrap) {
            this.add(new RegistryInfo<T>(key, elementCodec, registryBootstrap, List.of()));
        }
    }
}

