/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableInt;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.VanillaBiomeSettings;
import org.betterx.bclib.config.Configs;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InternalBiomeAPI {
    public static final BiomeAPI.BiomeType OTHER_NETHER = new BiomeAPI.BiomeType("OTHER_NETHER", BiomeAPI.BiomeType.NETHER);
    public static final BiomeAPI.BiomeType OTHER_END_LAND = new BiomeAPI.BiomeType("OTHER_END_LAND", BiomeAPI.BiomeType.END_LAND);
    public static final BiomeAPI.BiomeType OTHER_END_VOID = new BiomeAPI.BiomeType("OTHER_END_VOID", BiomeAPI.BiomeType.END_VOID);
    public static final BiomeAPI.BiomeType OTHER_END_CENTER = new BiomeAPI.BiomeType("OTHER_END_CENTER", BiomeAPI.BiomeType.END_CENTER);
    public static final BiomeAPI.BiomeType OTHER_END_BARRENS = new BiomeAPI.BiomeType("OTHER_END_BARRENS", BiomeAPI.BiomeType.END_BARRENS);
    static final Map<class_1959, BCLBiome> CLIENT = Maps.newHashMap();
    static final Map<class_6880<class_6796>, Integer> FEATURE_ORDER = Maps.newHashMap();
    static final Map<class_7871<class_1959>, AtomicInteger> BIOME_ADDITIONS = Maps.newHashMap();
    static final MutableInt FEATURE_ORDER_ID = new MutableInt(0);
    static final Map<class_5321<class_5363>, List<BiConsumer<class_2960, class_6880<class_1959>>>> MODIFICATIONS = Maps.newHashMap();
    static final Map<class_5321, List<BiConsumer<class_2960, class_6880<class_1959>>>> TAG_ADDERS = Maps.newHashMap();
    static class_2378<class_1959> biomeRegistry;
    static class_5455 registryAccess;
    private static final Set<class_2960> BIOMES_TO_SORT;

    public static class_5455 worldRegistryAccess() {
        return registryAccess;
    }

    public static void initRegistry(class_5455 access) {
        if (access != registryAccess) {
            registryAccess = access;
            class_2378 biomeRegistry = access.method_33310(class_7924.field_41236).orElse(null);
            if (biomeRegistry != InternalBiomeAPI.biomeRegistry) {
                InternalBiomeAPI.biomeRegistry = biomeRegistry;
                CLIENT.clear();
                BIOMES_TO_SORT.forEach(id -> {
                    class_1959 b = (class_1959)biomeRegistry.method_10223(id);
                    if (b == null) {
                        BCLib.LOGGER.info("Unknown Biome: " + id);
                    }
                });
            }
        }
    }

    public static void prepareNewLevel() {
        BIOMES_TO_SORT.clear();
    }

    public static void loadFabricAPIBiomes() {
    }

    public static void _runBiomeTagAdders() {
        for (Map.Entry<class_5321, List<BiConsumer<class_2960, class_6880<class_1959>>>> mod : TAG_ADDERS.entrySet()) {
            Stream<class_2960> s = null;
            if (mod.getKey() == class_1937.field_25180) {
                s = BCLBiomeRegistry.getAll(BiomeAPI.BiomeType.NETHER).map(k -> k.method_29177());
            } else if (mod.getKey() == class_1937.field_25181) {
                s = BCLBiomeRegistry.getAll(BiomeAPI.BiomeType.END).map(k -> k.method_29177());
            }
            if (s == null) continue;
            s.forEach(id -> {
                class_6880<class_1959> biomeHolder = BiomeAPI.getFromRegistry(id);
                if (biomeHolder != null && biomeHolder.method_40227()) {
                    ((List)mod.getValue()).forEach(c -> c.accept(id, biomeHolder));
                } else {
                    BCLib.LOGGER.info("No Holder for " + id);
                }
            });
        }
    }

    public static void applyModifications(class_1966 source, class_5321<class_5363> dimension) {
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("\nApply Modifications for " + dimension.method_29177() + source.toString().replace("\n", "\n    "));
        }
        Set biomes = source.method_28443();
        List<BiConsumer<class_2960, class_6880<class_1959>>> modifications = MODIFICATIONS.get(dimension);
        for (class_6880 biomeHolder : biomes) {
            if (!biomeHolder.method_40227()) continue;
            InternalBiomeAPI.applyModificationsAndUpdateFeatures(modifications, (class_6880<class_1959>)biomeHolder);
        }
    }

    private static void applyModificationsAndUpdateFeatures(List<BiConsumer<class_2960, class_6880<class_1959>>> modifications, class_6880<class_1959> biome) {
        class_2960 biomeID = BiomeAPI.getBiomeID(biome);
        if (modifications != null) {
            modifications.forEach(consumer -> consumer.accept(biomeID, biome));
        }
    }

    public static BCLBiome wrapBiome(class_5321<class_1959> biomeKey, BiomeAPI.BiomeType type) {
        return InternalBiomeAPI.wrapBiome(biomeKey, -1.0f, type);
    }

    public static BCLBiome wrapBiome(class_5321<class_1959> biomeKey, float genChance, BiomeAPI.BiomeType type) {
        return InternalBiomeAPI.wrapBiome(biomeKey, genChance < 0.0f ? null : (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build(), type);
    }

    public static BCLBiome wrapBiome(class_5321<class_1959> biomeKey, BCLBiome edgeBiome, int edgeBiomeSize, float genChance, BiomeAPI.BiomeType type) {
        VanillaBiomeSettings.Builder settings = VanillaBiomeSettings.createVanilla();
        if (genChance >= 0.0f) {
            settings.setGenChance(genChance);
        }
        settings.setEdgeSize(edgeBiomeSize);
        BCLBiome b = InternalBiomeAPI.wrapBiome(biomeKey, (VanillaBiomeSettings)settings.build(), type);
        b._setEdge(edgeBiome);
        return b;
    }

    private static BCLBiome wrapBiome(class_5321<class_1959> biomeKey, VanillaBiomeSettings setings, BiomeAPI.BiomeType type) {
        class_2378<BCLBiome> reg = BCLBiomeRegistry.registryOrNull();
        if (BCLBiomeRegistry.hasBiome(biomeKey, reg)) {
            return BCLBiomeRegistry.getBiome(biomeKey, reg);
        }
        BCLBiome bclBiome = new BCLBiome(biomeKey, (BCLBiomeSettings)setings);
        bclBiome._setIntendedType(type);
        InternalBiomeAPI.registerBuiltinBiome(bclBiome);
        return bclBiome;
    }

    public static BCLBiome wrapNativeBiome(class_5321<class_1959> biomeKey, BiomeAPI.BiomeType type) {
        class_2378<BCLBiome> reg = BCLBiomeRegistry.registryOrNull();
        if (!BCLBiomeRegistry.hasBiome(biomeKey, reg)) {
            BCLBiome bclBiome = InternalBiomeAPI.wrapBiome(biomeKey, type);
            BCLBiomeRegistry.register(bclBiome);
            InternalBiomeAPI.registerBuiltinBiome(bclBiome);
            return bclBiome;
        }
        return BCLBiomeRegistry.getBiome(biomeKey, reg);
    }

    public static int getBiomeRegistryModificationCount(class_7871<class_1959> registry) {
        if (registry == null) {
            return 0;
        }
        return BIOME_ADDITIONS.computeIfAbsent(registry, reg -> new AtomicInteger(0)).get();
    }

    public static BCLBiome registerBuiltinBiome(BCLBiome bclbiome) {
        return BiomeAPI.finishBiomeRegistration(bclbiome);
    }

    static {
        BIOMES_TO_SORT = Sets.newHashSet();
        DynamicRegistrySetupCallback.EVENT.register(registryManager -> {
            Optional oBiomeRegistry = registryManager.asDynamicRegistryManager().method_33310(class_7924.field_41236);
            if (oBiomeRegistry.isPresent()) {
                RegistryEntryAddedCallback.event((class_2378)((class_2378)oBiomeRegistry.get())).register((rawId, id, biome) -> {
                    BCLBiome b = BiomeAPI.getBiome(id);
                    if ("minecraft".equals(id.method_12836()) || BCLBiomeRegistry.isEmptyBiome(b)) {
                        // empty if block
                    }
                });
            } else {
                BCLib.LOGGER.warning("No valid Biome Registry available!", new Object[0]);
            }
        });
    }
}

