/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7243;
import net.minecraft.class_7891;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BCLBiomeRegistry {
    public static final class_5321<class_2378<BCLBiome>> BCL_BIOMES_REGISTRY = BCLBiomeRegistry.createRegistryKey(WorldsTogether.makeID("worldgen/betterx/biome"));
    public static final class_5321<class_2378<Codec<? extends BCLBiome>>> BCL_BIOME_CODEC_REGISTRY = BCLBiomeRegistry.createRegistryKey(WorldsTogether.makeID("worldgen/betterx/biome_codec"));
    public static class_2378<Codec<? extends BCLBiome>> BIOME_CODECS = FabricRegistryBuilder.from((class_2385)new class_2370(BCL_BIOME_CODEC_REGISTRY, Lifecycle.stable())).attribute(RegistryAttribute.MODDED).buildAndRegister();
    public static class_2370<BCLBiome> BUILTIN_BCL_BIOMES = new class_2370(BCL_BIOMES_REGISTRY, Lifecycle.stable());
    public static final BCLBiome EMPTY_BIOME = new BCLBiome(class_1972.field_9473.method_29177());
    private static boolean didCreate = false;

    public static boolean isEmptyBiome(class_2960 l) {
        return l == null || class_1972.field_9473.method_29177().equals((Object)l);
    }

    public static boolean isEmptyBiome(BCLBiome b) {
        return b == null || b == EMPTY_BIOME;
    }

    public static <E extends BCLBiome> Codec<E> registerBiomeCodec(class_2960 location, class_7243<E> codec) {
        class_2378.method_10230(BIOME_CODECS, (class_2960)location, (Object)codec.comp_640());
        return codec.comp_640();
    }

    @ApiStatus.Internal
    public static class_5321<BCLBiome> registerForDatagen(BCLBiome biome) {
        if (BUILTIN_BCL_BIOMES == null) {
            return biome.getBCLBiomeKey();
        }
        class_2378.method_39197(BUILTIN_BCL_BIOMES, biome.getBCLBiomeKey(), (Object)biome);
        return biome.getBCLBiomeKey();
    }

    public static void register(BCLBiome biome) {
        BCLBiomeRegistry.registerForDatagen(biome);
    }

    public static BCLBiome registerIfUnknown(class_6880<class_1959> biomeHolder, @NotNull BiomeAPI.BiomeType intendedType) {
        if (biomeHolder == null) {
            return null;
        }
        return BCLBiomeRegistry.registerIfUnknown((class_5321<class_1959>)((class_5321)biomeHolder.method_40230().orElse(null)), intendedType);
    }

    public static BCLBiome registerIfUnknown(class_5321<class_1959> biomeKey, @NotNull BiomeAPI.BiomeType intendedType) {
        if (biomeKey != null && !BCLBiomeRegistry.hasBiome(biomeKey, BCLBiomeRegistry.registryOrNull())) {
            BCLBiome bclBiome = new BCLBiome(biomeKey.method_29177(), intendedType);
            BCLBiomeRegistry.register(bclBiome);
            return bclBiome;
        }
        return null;
    }

    public static boolean hasBiome(class_5321<class_1959> key, class_2378<BCLBiome> bclBiomes) {
        return BCLBiomeRegistry.hasBiome(key.method_29177(), bclBiomes);
    }

    public static boolean hasBiome(class_2960 loc, class_2378<BCLBiome> bclBiomes) {
        if (loc == null) {
            return false;
        }
        if (bclBiomes != null && bclBiomes.method_10250(loc)) {
            return true;
        }
        return BUILTIN_BCL_BIOMES.method_10250(loc);
    }

    public static BCLBiome getBiome(class_5321<class_1959> key, class_2378<BCLBiome> bclBiomes) {
        return BCLBiomeRegistry.getBiome(key.method_29177(), bclBiomes);
    }

    public static BCLBiome getBiome(class_2960 loc, class_2378<BCLBiome> bclBiomes) {
        if (bclBiomes != null && bclBiomes.method_10250(loc)) {
            return (BCLBiome)bclBiomes.method_10223(loc);
        }
        return (BCLBiome)BUILTIN_BCL_BIOMES.method_10223(loc);
    }

    public static BCLBiome getBiomeOrNull(class_2960 loc, class_2378<BCLBiome> bclBiomes) {
        if (!BCLBiomeRegistry.hasBiome(loc, bclBiomes)) {
            return null;
        }
        return BCLBiomeRegistry.getBiome(loc, bclBiomes);
    }

    public static BCLBiome getBiomeOrNull(class_5321<class_1959> key, class_2378<BCLBiome> bclBiomes) {
        return BCLBiomeRegistry.getBiomeOrNull(key.method_29177(), bclBiomes);
    }

    public static BCLBiome getBiomeOrEmpty(class_2960 loc, class_2378<BCLBiome> bclBiomes) {
        if (!BCLBiomeRegistry.hasBiome(loc, bclBiomes)) {
            return EMPTY_BIOME;
        }
        return BCLBiomeRegistry.getBiome(loc, bclBiomes);
    }

    public static BCLBiome getBiomeOrEmpty(class_5321<class_1959> key, class_2378<BCLBiome> bclBiomes) {
        return BCLBiomeRegistry.getBiomeOrEmpty(key.method_29177(), bclBiomes);
    }

    private static <T> class_5321<class_2378<T>> createRegistryKey(class_2960 location) {
        return class_5321.method_29180((class_2960)location);
    }

    private static Codec<? extends BCLBiome> bootstrapCodecs(class_2378<Codec<? extends BCLBiome>> registry) {
        return (Codec)class_2378.method_10230(registry, (class_2960)BCLib.makeID("biome"), (Object)BCLBiome.KEY_CODEC.comp_640());
    }

    public static class_2378<BCLBiome> registryOrNull() {
        if (WorldBootstrap.getLastRegistryAccess() == null) {
            return null;
        }
        return WorldBootstrap.getLastRegistryAccess().method_33310(BCL_BIOMES_REGISTRY).orElse(null);
    }

    public static Stream<class_5321<BCLBiome>> getAll(BiomeAPI.BiomeType dim) {
        HashSet result = new HashSet();
        class_2378<BCLBiome> reg = BCLBiomeRegistry.registryOrNull();
        if (reg != null) {
            reg.method_29722().stream().filter(e -> ((BCLBiome)e.getValue()).getIntendedType().is(dim)).map(e -> (class_5321)e.getKey()).forEach(k -> result.add(k));
        }
        if (BUILTIN_BCL_BIOMES != null) {
            BUILTIN_BCL_BIOMES.method_29722().stream().filter(e -> ((BCLBiome)e.getValue()).getIntendedType().is(dim)).map(e -> (class_5321)e.getKey()).filter(k -> !result.contains(k)).forEach(k -> result.add(k));
        }
        return result.stream();
    }

    private static class_2378<BCLBiome> getBclBiomesRegistry(@Nullable class_5455 access) {
        if (access != null) {
            return (class_2378)access.method_33310(BCL_BIOMES_REGISTRY).orElse(BUILTIN_BCL_BIOMES);
        }
        return BUILTIN_BCL_BIOMES;
    }

    @ApiStatus.Internal
    public static void register() {
        BCLBiomeRegistry.bootstrapCodecs(BIOME_CODECS);
    }

    @ApiStatus.Internal
    public static void bootstrap(class_7891<BCLBiome> ctx) {
    }

    private static void onBiomeLoad(class_2378<BCLBiome> registry, int rawID, class_2960 id, BCLBiome biome) {
        if (!"minecraft".equals(id.method_12836())) {
            if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_NETHER)) {
                for (class_6544.class_4762 params : biome.parameterPoints) {
                    NetherBiomes.addNetherBiome(biome.getBiomeKey(), (class_6544.class_4762)params);
                }
            } else if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_END_CENTER)) {
                TheEndBiomes.addMainIslandBiome(biome.getBiomeKey(), (double)1.0);
            } else if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_END_BARRENS)) {
                TheEndBiomes.addBarrensBiome(biome.getParentBiome().getBiomeKey(), biome.getBiomeKey(), (double)1.0);
            } else if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_END_LAND)) {
                TheEndBiomes.addHighlandsBiome(biome.getBiomeKey(), (double)1.0);
                TheEndBiomes.addMidlandsBiome(biome.getBiomeKey(), biome.getBiomeKey(), (double)1.0);
            } else if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_END_VOID)) {
                TheEndBiomes.addSmallIslandsBiome(biome.getBiomeKey(), (double)1.0);
            } else {
                BCLib.LOGGER.info("Did not manage biome " + biome);
            }
        }
    }

    static {
        DynamicRegistrySetupCallback.EVENT.register(registryManager -> {
            Optional oBCLBiomeRegistry = registryManager.asDynamicRegistryManager().method_33310(BCL_BIOMES_REGISTRY);
            if (oBCLBiomeRegistry.isPresent()) {
                class_2378 registry = (class_2378)oBCLBiomeRegistry.orElseThrow();
                RegistryEntryAddedCallback.event((class_2378)((class_2378)oBCLBiomeRegistry.get())).register((rawId, loc, biome) -> BCLBiomeRegistry.onBiomeLoad((class_2378<BCLBiome>)registry, rawId, loc, biome));
            } else {
                BCLib.LOGGER.warning("No valid BCLBiome Registry available!", new Object[0]);
            }
        });
    }
}

