/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.storage;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.chiselsandbits.storage.IStorageHandler;
import mod.chiselsandbits.storage.IThreadAwareStorageEngine;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

final class VersionedStorageEngine
implements IThreadAwareStorageEngine {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int minimalVersion;
    private final List<IStorageHandler<?>> handlers;
    private final int currentVersion;
    private final IStorageHandler<?> saveHandler;

    VersionedStorageEngine(LinkedList<IStorageHandler<?>> handlers) {
        this(0, handlers);
    }

    VersionedStorageEngine(int minimalVersion, LinkedList<IStorageHandler<?>> handlers) {
        Validate.notEmpty(handlers);
        this.minimalVersion = minimalVersion;
        this.handlers = Collections.unmodifiableList(handlers);
        this.saveHandler = handlers.getLast();
        this.currentVersion = minimalVersion + handlers.size() - 1;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 compoundTag = new class_2487();
        this.serializeNBTInto(compoundTag);
        return compoundTag;
    }

    @Override
    public void serializeNBTInto(class_2487 tag) {
        tag.method_10569("version", this.currentVersion);
        tag.method_10566("data", this.saveHandler.serializeNBT());
    }

    @Override
    public void deserializeNBT(@NotNull class_2487 nbt) {
        IStorageHandler<?> storageHandler = this.readStorageHandler(nbt);
        if (storageHandler == null) {
            return;
        }
        storageHandler.deserializeNBT(nbt.method_10562("data"));
    }

    @Nullable
    private IStorageHandler<?> readStorageHandler(@NotNull class_2487 nbt) {
        int version;
        if (nbt.method_33133()) {
            LOGGER.warn("Empty NBT tag received, ignoring.");
            return null;
        }
        if (!nbt.method_10545("version")) {
            LOGGER.warn("The given NBT did not contain a versioned storage data entry. Missing the version!");
        }
        int n = version = nbt.method_10545("version") ? nbt.method_10550("version") : this.minimalVersion;
        if (version < this.minimalVersion) {
            throw new IllegalArgumentException("The given NBT did contained a version storage data entry, which is of an unsupported version. The version is " + version + ", but the minimal version is " + this.minimalVersion);
        }
        if (version > this.currentVersion) {
            throw new IllegalArgumentException("The given NBT did contained a version storage data entry, which is of an unsupported version. The version is " + version + ", but the current version is " + this.currentVersion);
        }
        int index = version - this.minimalVersion;
        return this.handlers.get(index);
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        packetBuffer.method_10794(this.serializeNBT());
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.deserializeNBT(Objects.requireNonNull(packetBuffer.method_30617()));
    }

    @Override
    public Collection<? extends IStorageHandler<?>> getHandlers() {
        return this.handlers;
    }

    @Override
    public CompletableFuture<Void> deserializeOffThread(class_2487 tag, Executor ioExecutor, Executor gameExecutor) {
        IStorageHandler<?> storageHandler = this.readStorageHandler(tag);
        if (storageHandler == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.doDeserializeOffThread(storageHandler, tag, ioExecutor, gameExecutor);
    }

    private <P> CompletableFuture<Void> doDeserializeOffThread(IStorageHandler<P> handler, class_2487 tag, Executor ioExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> handler.readPayloadOffThread(tag.method_10562("data")), ioExecutor).thenAcceptAsync(handler::syncPayloadOnGameThread, gameExecutor);
    }
}

