/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.neighborhood;

import java.util.EnumMap;
import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.neighborhood.BlockNeighborhood;
import mod.chiselsandbits.neighborhood.BlockNeighborhoodEntry;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockNeighborhoodBuilder
implements IBlockNeighborhoodBuilder {
    private static final BlockNeighborhoodBuilder INSTANCE = new BlockNeighborhoodBuilder();

    private BlockNeighborhoodBuilder() {
    }

    public static BlockNeighborhoodBuilder getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public IBlockNeighborhood build(@Nullable Function<class_2350, IBlockInformation> neighborhoodBlockStateProvider, @Nullable Function<class_2350, IAreaAccessor> neighborhoodAreaAccessorProvider) {
        EnumMap<class_2350, BlockNeighborhoodEntry> neighborhoodMap = new EnumMap<class_2350, BlockNeighborhoodEntry>(class_2350.class);
        try (IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Key building");){
            for (class_2350 value : class_2350.values()) {
                IAreaAccessor accessor;
                IBlockInformation state = neighborhoodBlockStateProvider != null ? neighborhoodBlockStateProvider.apply(value) : BlockInformation.AIR;
                IAreaAccessor iAreaAccessor = accessor = neighborhoodAreaAccessorProvider != null ? neighborhoodAreaAccessorProvider.apply(value) : null;
                if (accessor == null) {
                    neighborhoodMap.put(value, new BlockNeighborhoodEntry(state));
                    continue;
                }
                neighborhoodMap.put(value, new BlockNeighborhoodEntry(state, accessor));
            }
            BlockNeighborhood blockNeighborhood = new BlockNeighborhood(neighborhoodMap);
            return blockNeighborhood;
        }
    }
}

