/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.snapshot;

import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IAreaMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.blockinformation.BlockInformation;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

public class MultiBlockMultiStateSnapshot
implements IMultiStateSnapshot {
    private Map<class_2338, IMultiStateSnapshot> snapshots;
    private class_243 startPoint;
    private class_243 endPoint;

    public MultiBlockMultiStateSnapshot(Map<class_2338, IMultiStateSnapshot> snapshots, class_243 startPoint, class_243 endPoint) {
        this.snapshots = snapshots;
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        if (!BlockPosStreamProvider.getForRange(startPoint, endPoint).allMatch(snapshots::containsKey)) {
            throw new IllegalArgumentException("Not all required block positions are part of the given range.");
        }
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new Identifier(this.snapshots.values());
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return this.snapshots.values().stream().flatMap(IAreaAccessor::stream);
    }

    @Override
    public boolean isInside(class_243 inAreaTarget) {
        class_2338 inAreaOffset = VectorUtils.toBlockPos(inAreaTarget);
        return this.isInside(inAreaOffset, inAreaTarget.method_1020(class_243.method_24954((class_2382)inAreaOffset)));
    }

    @Override
    public boolean isInside(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        class_2338 targetPos = VectorUtils.toBlockPos(this.startPoint).method_10081((class_2382)inAreaBlockPosOffset);
        return this.snapshots.containsKey(targetPos) && this.snapshots.get(targetPos).isInside(class_2338.field_10980, inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        Map<class_2338, IMultiStateSnapshot> copiedSnapshots = this.snapshots.keySet().stream().collect(Collectors.toMap(Function.identity(), pos -> this.snapshots.get(pos).createSnapshot()));
        return new MultiBlockMultiStateSnapshot(copiedSnapshots, this.startPoint, this.endPoint);
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(this.startPoint.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.endPoint.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())).map(positionMutator::mutate).map(position -> class_243.method_24954((class_2382)position).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())).map(position -> {
            class_2338 blockPos = VectorUtils.toBlockPos(position);
            class_243 inBlockOffset = position.method_1020(class_243.method_24954((class_2382)blockPos));
            return this.getInBlockTarget(blockPos, inBlockOffset);
        }).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(this.startPoint.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.endPoint.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), blockPos -> {
            class_2382 target = positionMutator.mutate((class_2382)blockPos);
            class_243 scaledTarget = class_243.method_24954((class_2382)target).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            class_2338 blockTarget = VectorUtils.toBlockPos(scaledTarget);
            class_243 inBlockOffset = scaledTarget.method_1020(class_243.method_24954((class_2382)blockPos));
            Optional<IStateEntryInfo> targetCandidate = this.getInBlockTarget((class_2338)blockPos, inBlockOffset);
            targetCandidate.ifPresent(consumer);
        });
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(class_243 inAreaTarget) {
        class_2338 inAreaOffset = VectorUtils.toBlockPos(inAreaTarget);
        return this.getInBlockTarget(inAreaOffset, inAreaTarget.method_1020(class_243.method_24954((class_2382)inAreaOffset)));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        class_2338 targetPos = VectorUtils.toBlockPos(this.startPoint).method_10081((class_2382)inAreaBlockPosOffset);
        if (!this.snapshots.containsKey(targetPos)) {
            throw new IllegalArgumentException("The given position is not in the current snapshot!");
        }
        return this.snapshots.get(targetPos).getInBlockTarget(class_2338.field_10980, inBlockTarget);
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return this.snapshots.values().stream().flatMap(IAreaMutator::mutableStream);
    }

    @Override
    public void setInAreaTarget(IBlockInformation blockInformation, class_243 inAreaTarget) throws SpaceOccupiedException {
        class_243 workingTarget = inAreaTarget.method_1019(this.startPoint);
        class_2338 offset = VectorUtils.toBlockPos(workingTarget);
        class_243 inBlockTarget = new class_243(workingTarget.method_10216() - (double)offset.method_10263(), workingTarget.method_10214() - (double)offset.method_10264(), workingTarget.method_10215() - (double)offset.method_10260());
        this.setInBlockTarget(blockInformation, offset, inBlockTarget);
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) throws SpaceOccupiedException {
        class_243 workingTarget = class_243.method_24954((class_2382)inAreaBlockPosOffset).method_1019(inBlockTarget);
        if (workingTarget.method_10216() < this.startPoint.method_10216() || workingTarget.method_10214() < this.startPoint.method_10214() || workingTarget.method_10215() < this.startPoint.method_10215() || workingTarget.method_10216() > this.endPoint.method_10216() || workingTarget.method_10214() > this.endPoint.method_10214() || workingTarget.method_10215() > this.endPoint.method_10215()) {
            throw new IllegalArgumentException("The given target is outside of the operating range of this snapshot!");
        }
        if (!this.snapshots.containsKey(inAreaBlockPosOffset)) {
            throw new IllegalArgumentException("The given in area block pos offset is outside of the target range!");
        }
        this.snapshots.get(inAreaBlockPosOffset).setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(class_243 inAreaTarget) {
        class_243 workingTarget = inAreaTarget.method_1019(this.startPoint);
        class_2338 offset = VectorUtils.toBlockPos(workingTarget);
        class_243 inBlockTarget = new class_243(workingTarget.method_10216() - (double)offset.method_10263(), workingTarget.method_10214() - (double)offset.method_10264(), workingTarget.method_10215() - (double)offset.method_10260());
        this.clearInBlockTarget(offset, inBlockTarget);
    }

    @Override
    public void clearInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        class_243 workingTarget = class_243.method_24954((class_2382)inAreaBlockPosOffset).method_1019(inBlockTarget);
        if (workingTarget.method_10216() < this.startPoint.method_10216() || workingTarget.method_10214() < this.startPoint.method_10214() || workingTarget.method_10215() < this.startPoint.method_10215() || workingTarget.method_10216() > this.endPoint.method_10216() || workingTarget.method_10214() > this.endPoint.method_10214() || workingTarget.method_10215() > this.endPoint.method_10215()) {
            throw new IllegalArgumentException("The given target is outside of the operating range of this snapshot!");
        }
        if (!this.snapshots.containsKey(inAreaBlockPosOffset)) {
            throw new IllegalArgumentException("The given in area block pos offset is outside of the target range!");
        }
        this.snapshots.get(inAreaBlockPosOffset).clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateItemStack toItemStack() {
        throw new NotImplementedException("Multi block snapshots can not be contained in an itemstack as of now.");
    }

    @Override
    public IMultiStateObjectStatistics getStatics() {
        return new IMultiStateObjectStatistics(){

            @Override
            public class_2487 serializeNBT() {
                return new class_2487();
            }

            @Override
            public void deserializeNBT(class_2487 nbt) {
            }

            @Override
            public IBlockInformation getPrimaryState() {
                return this.getStateCounts().entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(BlockInformation.AIR);
            }

            @Override
            public boolean isEmpty() {
                Map<IBlockInformation, Integer> stateMap = this.getStateCounts();
                return stateMap.size() == 1 && stateMap.getOrDefault(BlockInformation.AIR, 0) > 0;
            }

            @Override
            public Map<IBlockInformation, Integer> getStateCounts() {
                return MultiBlockMultiStateSnapshot.this.stream().collect(Collectors.toMap(IStateEntryInfo::getBlockInformation, s -> 1, Integer::sum));
            }

            @Override
            public boolean shouldCheckWeakPower() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getFullnessFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getSlipperiness() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightEmissionFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightBlockingFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getRelativeBlockHardness(class_1657 player) {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canPropagateSkylight() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canSustainGrassBelow() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public BitSet getCollideableEntries(CollisionType collisionType) {
                return BitSet.valueOf(new long[0]);
            }
        };
    }

    @Override
    public void rotate(class_2350.class_2351 axis, int rotationCount) {
        class_243 center = this.startPoint.method_1019(this.endPoint).method_18805(0.5, 0.5, 0.5);
        Map<class_2338, IMultiStateSnapshot> rotatedParts = this.snapshots.entrySet().stream().collect(Collectors.toMap(e -> {
            class_243 offSetPos = class_243.method_24954((class_2382)((class_2382)e.getKey())).method_1020(center);
            class_243 rotatedOffset = VectorUtils.rotateMultipleTimes90Degrees(offSetPos, axis, rotationCount);
            return VectorUtils.toBlockPos(this.startPoint.method_1019(rotatedOffset));
        }, e -> {
            IMultiStateSnapshot clone = ((IMultiStateSnapshot)e.getValue()).clone();
            clone.rotate(axis, rotationCount);
            return clone;
        }));
        class_243 rotatedStartPoint = VectorUtils.rotateMultipleTimes90Degrees(this.startPoint.method_1020(center), axis, rotationCount).method_1019(center);
        class_243 rotatedEndPoint = VectorUtils.rotateMultipleTimes90Degrees(this.endPoint.method_1020(center), axis, rotationCount).method_1019(center);
        class_243 newStartPoint = VectorUtils.minimize(rotatedStartPoint, rotatedEndPoint);
        class_243 newEndPoint = VectorUtils.maximize(rotatedStartPoint, rotatedEndPoint);
        this.snapshots = rotatedParts;
        this.startPoint = newStartPoint;
        this.endPoint = newEndPoint;
    }

    @Override
    public void mirror(class_2350.class_2351 axis) {
        class_243 center = this.startPoint.method_1019(this.endPoint).method_18805(0.5, 0.5, 0.5);
        this.snapshots = this.snapshots.entrySet().stream().collect(Collectors.toMap(e -> {
            int mirroredX = axis == class_2350.class_2351.field_11048 ? (int)(center.method_10216() - (double)((class_2338)e.getKey()).method_10263()) : ((class_2338)e.getKey()).method_10263();
            int mirroredY = axis == class_2350.class_2351.field_11052 ? (int)(center.method_10214() - (double)((class_2338)e.getKey()).method_10264()) : ((class_2338)e.getKey()).method_10264();
            int mirroredZ = axis == class_2350.class_2351.field_11051 ? (int)(center.method_10215() - (double)((class_2338)e.getKey()).method_10260()) : ((class_2338)e.getKey()).method_10260();
            return new class_2338(mirroredX, mirroredY, mirroredZ);
        }, e -> {
            IMultiStateSnapshot clone = ((IMultiStateSnapshot)e.getValue()).clone();
            clone.mirror(axis);
            return clone;
        }));
    }

    @Override
    public IMultiStateSnapshot clone() {
        Map<class_2338, IMultiStateSnapshot> clonedSnapshots = this.snapshots.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IMultiStateSnapshot)e.getValue()).clone()));
        return new MultiBlockMultiStateSnapshot(clonedSnapshots, this.startPoint, this.endPoint);
    }

    @Override
    @NotNull
    public class_238 getBoundingBox() {
        return new class_238(this.startPoint.method_10216(), this.startPoint.method_10214(), this.startPoint.method_10215(), this.endPoint.method_10216(), this.endPoint.method_10214(), this.endPoint.method_10215());
    }

    private static final class Identifier
    implements IAreaShapeIdentifier {
        private final Collection<IAreaShapeIdentifier> inners;

        public Identifier(Collection<IMultiStateSnapshot> innerSnapshots) {
            this.inners = innerSnapshots.stream().map(IAreaAccessor::createNewShapeIdentifier).collect(Collectors.toList());
        }

        public int hashCode() {
            return Objects.hash(this.inners);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.inners.equals(that.inners);
        }
    }
}

