/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.communi.suggestu.scena.core.entity.IPlayerInventoryManager;
import java.util.List;
import mod.chiselsandbits.api.exceptions.SealingNotSupportedException;
import mod.chiselsandbits.api.item.tool.ISealantItem;
import mod.chiselsandbits.api.sealing.ISupportsSealing;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SealantItem
extends class_1792
implements ISealantItem {
    private final String CONST_INTERACTION = "Interaction";
    private final String CONST_SIMULATION = "Simulation";

    public SealantItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public boolean isInteracting(class_1799 stack) {
        return stack.method_7909() == this && stack.method_7948().method_10545("Interaction");
    }

    @Override
    public class_1799 getInteractionTarget(class_1799 stack) {
        return this.isInteracting(stack) ? class_1799.method_7915((class_2487)stack.method_7911("Interaction")) : class_1799.field_8037;
    }

    @Override
    public boolean isRunningASimulatedInteraction(class_1799 stack) {
        return this.isInteracting(stack) && stack.method_7948().method_10545("Simulation");
    }

    @Override
    public float getBobbingTickCount() {
        return 32.0f;
    }

    public int method_7881(@NotNull class_1799 stack) {
        return 64;
    }

    public int method_7837() {
        return 5;
    }

    public static void spawnParticles(class_243 location, class_1799 stack, class_1937 world) {
        for (int i = 0; i < 20; ++i) {
            class_243 motion = VectorUtils.offsetRandomly(class_243.field_1353, world.field_9229, 0.125f);
            world.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), location.field_1352, location.field_1351, location.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        }
    }

    public void method_7840(@NotNull class_1799 stack, @NotNull class_1937 worldIn, @NotNull class_1309 entityLiving, int timeLeft) {
        if (!(entityLiving instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entityLiving;
        if (this.isInteracting(stack)) {
            class_1799 interactionTarget = this.getInteractionTarget(stack);
            player.method_31548().method_7398(interactionTarget);
            stack.method_7948().method_10551("Interaction");
        }
    }

    @NotNull
    public class_1799 method_7861(@NotNull class_1799 stack, @NotNull class_1937 worldIn, @NotNull class_1309 entityLiving) {
        if (!(entityLiving instanceof class_1657)) {
            return stack;
        }
        class_1657 player = (class_1657)entityLiving;
        if (this.isInteracting(stack)) {
            class_1799 target = this.getInteractionTarget(stack);
            class_1799 pattern = SealantItem.createPattern(target);
            if (worldIn.field_9236) {
                SealantItem.spawnParticles(entityLiving.method_5836(1.0f).method_1019(entityLiving.method_5720().method_1021(0.5)), target, worldIn);
                return stack;
            }
            if (!pattern.method_7960()) {
                IPlayerInventoryManager.getInstance().giveToPlayer(player, pattern);
            }
            stack.method_7948().method_10551("Interaction");
            stack.method_7956(1, entityLiving, p -> p.method_20236(p.method_6058()));
        }
        return stack;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 worldIn, class_1657 playerIn, @NotNull class_1268 handIn) {
        class_1799 itemstack = playerIn.method_5998(handIn);
        if (this.isInteracting(itemstack)) {
            playerIn.method_6019(handIn);
            return new class_1271(class_1269.field_5811, (Object)itemstack);
        }
        class_1268 otherHand = handIn == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        class_1799 itemInOtherHand = playerIn.method_5998(otherHand);
        if (SealantItem.createPattern(itemInOtherHand).method_7909() != itemInOtherHand.method_7909() && itemInOtherHand.method_7909() instanceof ISupportsSealing) {
            class_1799 item = itemInOtherHand.method_7972();
            class_1799 target = item.method_7971(1);
            playerIn.method_6019(handIn);
            itemstack.method_7948().method_10566("Interaction", (class_2520)target.method_7953(new class_2487()));
            playerIn.method_6122(otherHand, item);
            return new class_1271(class_1269.field_5812, (Object)itemstack);
        }
        return new class_1271(class_1269.field_5812, (Object)itemstack);
    }

    private static class_1799 createPattern(class_1799 targetStack) {
        if (targetStack.method_7909() instanceof ISupportsSealing) {
            try {
                return ((ISupportsSealing)targetStack.method_7909()).seal(targetStack);
            }
            catch (SealingNotSupportedException e) {
                return targetStack;
            }
        }
        return targetStack;
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        HelpTextUtils.build(LocalStrings.HelpSealant, tooltip, new Object[0]);
    }
}

