/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.render;

import com.communi.suggestu.scena.core.util.TransformationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.measuring.MeasuringType;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.measures.MeasuringManager;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_761;
import org.joml.Vector3f;

public final class MeasurementRenderer {
    private static final MeasurementRenderer INSTANCE = new MeasurementRenderer();

    private MeasurementRenderer() {
    }

    public static MeasurementRenderer getInstance() {
        return INSTANCE;
    }

    public void renderMeasurements(class_4587 poseStack) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        Collection<? extends IMeasurement> measurements = MeasuringManager.getInstance().getInWorld((class_1937)class_310.method_1551().field_1687);
        class_243 vector3d = class_310.method_1551().field_1773.method_19418().method_19326();
        double xView = vector3d.method_10216();
        double yView = vector3d.method_10214();
        double zView = vector3d.method_10215();
        measurements.forEach(measurement -> {
            class_243 startPos = measurement.getFrom();
            class_238 measurementBB = new class_238(class_243.field_1353, measurement.getSize().method_1031(1.0E-4, 1.0E-4, 1.0E-4));
            class_265 boundingShape = class_259.method_1078((class_238)measurementBB);
            if (measurement.getMode().getGroup().map(g -> g != MeasuringType.DISTANCE).orElse(false).booleanValue()) {
                class_761.method_3291((class_4587)poseStack, (class_4588)class_310.method_1551().method_22940().method_23000().getBuffer(ModRenderTypes.MEASUREMENT_LINES.get()), (class_265)boundingShape, (double)(startPos.method_10216() - xView), (double)(startPos.method_10214() - yView), (double)(startPos.method_10215() - zView), (float)((float)measurement.getMode().getColorVector().method_10216()), (float)((float)measurement.getMode().getColorVector().method_10214()), (float)((float)measurement.getMode().getColorVector().method_10215()), (float)((float)measurement.getMode().getAlphaChannel()));
                class_243 lengths = VectorUtils.absolute(measurement.getTo().method_1020(measurement.getFrom()));
                class_243 centerPos = measurement.getFrom().method_1019(measurement.getTo()).method_18805(0.5, 0.5, 0.5);
                if (lengths.method_10214() > 0.0625) {
                    this.renderMeasurementSize(poseStack, (IMeasurement)measurement, lengths.method_10214(), new class_243(measurement.getFrom().method_10216(), centerPos.method_10214(), measurement.getFrom().method_10215()));
                }
                if (lengths.method_10216() > 0.0625) {
                    this.renderMeasurementSize(poseStack, (IMeasurement)measurement, lengths.method_10216(), new class_243(centerPos.method_10216(), measurement.getFrom().method_10214(), measurement.getFrom().method_10215()));
                }
                if (lengths.method_10215() > 0.0625) {
                    this.renderMeasurementSize(poseStack, (IMeasurement)measurement, lengths.method_10215(), new class_243(measurement.getFrom().method_10216(), measurement.getFrom().method_10214(), centerPos.method_10215()));
                }
            } else if (measurement.getMode().getGroup().map(g -> g == MeasuringType.DISTANCE).orElse(false).booleanValue()) {
                class_4588 bufferIn = class_310.method_1551().method_22940().method_23000().getBuffer(ModRenderTypes.MEASUREMENT_LINES.get());
                bufferIn.method_22918(poseStack.method_23760().method_23761(), (float)(measurement.getFrom().method_10216() - xView), (float)(measurement.getFrom().method_10214() - yView), (float)(measurement.getFrom().method_10215() - zView)).method_22915((float)measurement.getMode().getColorVector().method_10216(), (float)measurement.getMode().getColorVector().method_10214(), (float)measurement.getMode().getColorVector().method_10215(), (float)measurement.getMode().getAlphaChannel()).method_23763(poseStack.method_23760().method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
                bufferIn.method_22918(poseStack.method_23760().method_23761(), (float)(measurement.getTo().method_10216() - xView), (float)(measurement.getTo().method_10214() - yView), (float)(measurement.getTo().method_10215() - zView)).method_22915((float)measurement.getMode().getColorVector().method_10216(), (float)measurement.getMode().getColorVector().method_10214(), (float)measurement.getMode().getColorVector().method_10215(), (float)measurement.getMode().getAlphaChannel()).method_23763(poseStack.method_23760().method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
                class_243 lengths = VectorUtils.absolute(measurement.getTo().method_1020(measurement.getFrom()));
                double totalLength = lengths.method_1033();
                class_243 centerPos = measurement.getFrom().method_1019(measurement.getTo()).method_18805(0.5, 0.5, 0.5);
                if (totalLength > 0.0625) {
                    this.renderMeasurementSize(poseStack, (IMeasurement)measurement, totalLength, centerPos);
                }
            }
            class_310.method_1551().method_22940().method_23000().method_22994(ModRenderTypes.MEASUREMENT_LINES.get());
        });
    }

    private void renderMeasurementSize(class_4587 matrixStack, IMeasurement measurement, double length, class_243 position) {
        double letterSize = 5.0;
        double zScale = 0.001;
        class_327 fontRenderer = class_310.method_1551().field_1772;
        class_2561 size = this.formatLength(measurement.getMode(), length);
        class_2561 owner = this.getOwnerName(measurement.getOwner());
        float scale = this.getScale(length);
        class_243 vector3d = class_310.method_1551().field_1773.method_19418().method_19326();
        double xView = vector3d.method_10216();
        double yView = vector3d.method_10214();
        double zView = vector3d.method_10215();
        matrixStack.method_22903();
        matrixStack.method_22904(position.method_10216() - xView, position.method_10214() + (double)scale * 5.0 - yView, position.method_10215() - zView);
        this.performBillboardRotations(matrixStack);
        matrixStack.method_22905(scale, -scale, 0.001f);
        matrixStack.method_22904((double)(-fontRenderer.method_27525((class_5348)size)) * 0.5, 0.0, 0.0);
        RenderSystem.disableDepthTest();
        class_4597.class_4598 buffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        fontRenderer.method_27521(size.getString(), 0.0f, 0.0f, measurement.getMode().getColor().method_16357(), false, matrixStack.method_23760().method_23761(), (class_4597)buffer, class_327.class_6415.field_33994, 0, 0xF000F0);
        double d = (double)(-fontRenderer.method_27525((class_5348)owner)) * 0.5;
        Objects.requireNonNull(fontRenderer);
        matrixStack.method_22904(d, (double)(-9), 0.0);
        fontRenderer.method_27521(owner.getString(), 0.0f, 0.0f, measurement.getMode().getColor().method_16357(), false, matrixStack.method_23760().method_23761(), (class_4597)buffer, class_327.class_6415.field_33994, 0, 0xF000F0);
        buffer.method_22993();
        RenderSystem.enableDepthTest();
        matrixStack.method_22909();
    }

    private class_2561 formatLength(MeasuringMode mode, double length) {
        MeasuringType type = mode.getType();
        if (type == MeasuringType.DISTANCE) {
            return class_2561.method_43470((String)new DecimalFormat("#.0#").format(length));
        }
        if (type == MeasuringType.BLOCK) {
            return class_2561.method_43469((String)"chiselsandbits.measurements.lengths.block", (Object[])new Object[]{new DecimalFormat("#").format(Math.floor(length + 1.0))});
        }
        return class_2561.method_43469((String)"chiselsandbits.measurements.lengths.bit", (Object[])new Object[]{new DecimalFormat("#").format(Math.floor(length * 16.0))});
    }

    private float getScale(double maxLen) {
        double maxFontSize = 0.04;
        double minFontSize = 0.004;
        double delta = Math.min(1.0, maxLen / 4.0);
        double scale = 0.04 * delta + 0.004 * (1.0 - delta);
        if (maxLen < 0.25) {
            scale = 0.004;
        }
        return (float)Math.min(0.04, scale);
    }

    private void performBillboardRotations(class_4587 matrixStack) {
        class_1297 view;
        Object object = view = class_310.method_1551().field_1719 != null ? class_310.method_1551().field_1719 : class_310.method_1551().field_1724;
        if (view != null) {
            float yaw = view.field_5982 + (view.method_36454() - view.field_5982) * class_310.method_1551().method_1488();
            matrixStack.method_22907(TransformationUtils.quatFromXYZ((Vector3f)new Vector3f(0.0f, 180.0f - yaw, 0.0f), (boolean)true));
            float pitch = view.field_6004 + (view.method_36455() - view.field_6004) * class_310.method_1551().method_1488();
            matrixStack.method_22907(TransformationUtils.quatFromXYZ((Vector3f)new Vector3f(-pitch, 0.0f, 0.0f), (boolean)true));
        }
    }

    private class_2561 getOwnerName(UUID id) {
        class_640 playerInfo;
        if (id == (class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_5667() : UUID.randomUUID())) {
            return class_2561.method_43471((String)"chiselsandbits.measurements.owners.you");
        }
        class_640 class_6402 = playerInfo = class_310.method_1551().method_1562() != null ? class_310.method_1551().method_1562().method_2871(id) : null;
        if (playerInfo == null) {
            return class_2561.method_43471((String)"chiselsandbits.measurements.owners.unknown");
        }
        return class_2561.method_43469((String)"chiselsandbits.measurements.owners.by", (Object[])new Object[]{playerInfo.method_2971() != null ? this.formatPlayerDisplayName(playerInfo, playerInfo.method_2971().method_27661()) : this.formatPlayerDisplayName(playerInfo, class_268.method_1142((class_270)playerInfo.method_2955(), (class_2561)class_2561.method_43470((String)playerInfo.method_2966().getName())))});
    }

    private class_2561 formatPlayerDisplayName(class_640 p_238524_1_, class_5250 p_238524_2_) {
        return p_238524_1_.method_2958() == class_1934.field_9219 ? p_238524_2_.method_27692(class_124.field_1056) : p_238524_2_;
    }
}

