/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.data;

import com.communi.suggestu.scena.core.client.models.data.IModelDataBuilder;
import com.communi.suggestu.scena.core.client.models.data.IModelDataManager;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.block.entities.ChiseledBlockEntity;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.FluidRenderingManager;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.client.multistate.rendering.RenderingAreaAccessor;
import mod.chiselsandbits.client.util.BlockInformationUtils;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModModelProperties;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public class ChiseledBlockModelDataExecutor {
    private static ExecutorService recalculationService;

    public static void updateModelDataCore(ChiseledBlockEntity tileEntity, Runnable onCompleteCallback) {
        ChiseledBlockModelDataExecutor.ensureThreadPoolSetup();
        IBlockNeighborhood neighborhood = IBlockNeighborhoodBuilder.getInstance().build(direction -> {
            class_2680 state = Objects.requireNonNull(tileEntity.method_10997()).method_8320(tileEntity.method_11016().method_10081(direction.method_10163()));
            Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(tileEntity.method_10997().method_8321(tileEntity.method_11016().method_10081(direction.method_10163()))));
            return new BlockInformation(state, additionalStateInfo);
        }, direction -> {
            class_2586 otherTileEntity = Objects.requireNonNull(tileEntity.method_10997()).method_8321(tileEntity.method_11016().method_10081(direction.method_10163()));
            if (otherTileEntity instanceof IAreaAccessor) {
                return (IAreaAccessor)otherTileEntity;
            }
            return null;
        });
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            LinkedHashMap renderTypedModels = Maps.newLinkedHashMap();
            Set<class_1921> renderTypes = BlockInformationUtils.extractRenderTypes(tileEntity.getStatistics().getStateCounts().keySet());
            try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Extract model data from data");
                 IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Known render layer model building");){
                for (class_1921 chunkBufferLayer : renderTypes) {
                    BaseBakedBlockModel baked;
                    block52: {
                        ChiselRenderType solidType = ChiselRenderType.fromLayer(chunkBufferLayer, false);
                        ChiselRenderType fluidType = ChiselRenderType.fromLayer(chunkBufferLayer, true);
                        if (tileEntity.getStatistics().getStateCounts().isEmpty() || tileEntity.getStatistics().getStateCounts().size() == 1 && tileEntity.getStatistics().getStateCounts().containsKey(BlockInformation.AIR)) continue;
                        try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Known render layer model building for: " + solidType.name() + " and " + fluidType.name());){
                            IProfilerSection ignored4;
                            if (FluidRenderingManager.getInstance().isFluidRenderType(chunkBufferLayer)) {
                                ignored4 = ProfilingManager.getInstance().withSection("Combined model building");
                                try {
                                    ChiseledBlockBakedModel fluidModel;
                                    ChiseledBlockBakedModel solidModel;
                                    try (IProfilerSection ignored5 = ProfilingManager.getInstance().withSection("Solid");){
                                        solidModel = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), solidType, neighborhood, tileEntity.method_11016(), chunkBufferLayer);
                                    }
                                    try (IProfilerSection ignored5 = ProfilingManager.getInstance().withSection("Fluid");){
                                        fluidModel = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), fluidType, neighborhood, tileEntity.method_11016(), chunkBufferLayer);
                                    }
                                    ignored5 = ProfilingManager.getInstance().withSection("Model combining");
                                    try {
                                        baked = solidModel.isEmpty() ? fluidModel : (fluidModel.isEmpty() ? solidModel : new CombinedModel(solidModel, fluidModel));
                                        break block52;
                                    }
                                    finally {
                                        if (ignored5 != null) {
                                            ignored5.close();
                                        }
                                    }
                                }
                                finally {
                                    if (ignored4 != null) {
                                        ignored4.close();
                                    }
                                }
                            }
                            ignored4 = ProfilingManager.getInstance().withSection("Singular model building");
                            try {
                                baked = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), ChiselRenderType.fromLayer(chunkBufferLayer, false), neighborhood, tileEntity.method_11016(), chunkBufferLayer);
                            }
                            finally {
                                if (ignored4 != null) {
                                    ignored4.close();
                                }
                            }
                        }
                    }
                    renderTypedModels.put(chunkBufferLayer, baked);
                }
            }
            CombinedModel unknownRenderTypeModel = new CombinedModel((class_1087[])renderTypedModels.values().stream().filter(model -> model != NullBakedModel.instance).toArray(class_1087[]::new));
            return IModelDataBuilder.create().withInitial(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY, (Object)unknownRenderTypeModel).withInitial(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY, (Object)renderTypedModels).build();
        }, recalculationService).thenAcceptAsync(tileEntity::setModelData, (Executor)recalculationService)).thenRunAsync(onCompleteCallback, recalculationService)).thenRunAsync(() -> {
            if (class_310.method_1551().field_1687 == tileEntity.method_10997()) {
                IModelDataManager.getInstance().requestModelDataRefresh((class_2586)tileEntity);
                Objects.requireNonNull(class_310.method_1551().field_1687).method_8413(tileEntity.method_11016(), tileEntity.method_11010(), tileEntity.method_11010(), 8);
            }
        }, (Executor)class_310.method_1551());
    }

    public static void updateModelDataPerContainedState(final ChiseledBlockEntity tileEntity, Consumer<Table<class_1921, IBlockInformation, class_1087>> resultConsumer) {
        ChiseledBlockModelDataExecutor.ensureThreadPoolSetup();
        final IBlockNeighborhood neighborhood = IBlockNeighborhoodBuilder.getInstance().build(direction -> {
            class_2680 state = Objects.requireNonNull(tileEntity.method_10997()).method_8320(tileEntity.method_11016().method_10081(direction.method_10163()));
            Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(tileEntity.method_10997().method_8321(tileEntity.method_11016().method_10081(direction.method_10163()))));
            return new BlockInformation(state, additionalStateInfo);
        }, direction -> {
            class_2586 otherTileEntity = Objects.requireNonNull(tileEntity.method_10997()).method_8321(tileEntity.method_11016().method_10081(direction.method_10163()));
            if (otherTileEntity instanceof IAreaAccessor) {
                return (IAreaAccessor)otherTileEntity;
            }
            return null;
        });
        CompletableFuture.supplyAsync(new Supplier<Table<class_1921, IBlockInformation, class_1087>>(){

            @Override
            public Table<class_1921, IBlockInformation, class_1087> get() {
                HashBasedTable result = HashBasedTable.create();
                for (IBlockInformation blockInformation : tileEntity.getStatistics().getContainedStates()) {
                    Set<class_1921> renderTypes = BlockInformationUtils.extractRenderTypes(blockInformation);
                    RenderingAreaAccessor filtered = new RenderingAreaAccessor(blockInformation, tileEntity);
                    for (class_1921 renderType : renderTypes) {
                        BaseBakedBlockModel baked;
                        block41: {
                            ChiselRenderType solidType = ChiselRenderType.fromLayer(renderType, false);
                            ChiselRenderType fluidType = ChiselRenderType.fromLayer(renderType, true);
                            if (tileEntity.getStatistics().getStateCounts().isEmpty() || tileEntity.getStatistics().getStateCounts().size() == 1 && tileEntity.getStatistics().getStateCounts().containsKey(BlockInformation.AIR)) continue;
                            try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Known render layer model building for: " + solidType.name() + " and " + fluidType.name());){
                                IProfilerSection ignored4;
                                if (FluidRenderingManager.getInstance().isFluidRenderType(renderType)) {
                                    ignored4 = ProfilingManager.getInstance().withSection("Combined model building");
                                    try {
                                        ChiseledBlockBakedModel fluidModel;
                                        ChiseledBlockBakedModel solidModel;
                                        try (IProfilerSection ignored5 = ProfilingManager.getInstance().withSection("Solid");){
                                            solidModel = ChiseledBlockBakedModelManager.getInstance().get(filtered, blockInformation, solidType, neighborhood, tileEntity.method_11016(), renderType);
                                        }
                                        try (IProfilerSection ignored5 = ProfilingManager.getInstance().withSection("Fluid");){
                                            fluidModel = ChiseledBlockBakedModelManager.getInstance().get(filtered, blockInformation, fluidType, neighborhood, tileEntity.method_11016(), renderType);
                                        }
                                        ignored5 = ProfilingManager.getInstance().withSection("Model combining");
                                        try {
                                            baked = solidModel.isEmpty() ? fluidModel : (fluidModel.isEmpty() ? solidModel : new CombinedModel(solidModel, fluidModel));
                                            break block41;
                                        }
                                        finally {
                                            if (ignored5 != null) {
                                                ignored5.close();
                                            }
                                        }
                                    }
                                    finally {
                                        if (ignored4 != null) {
                                            ignored4.close();
                                        }
                                    }
                                }
                                ignored4 = ProfilingManager.getInstance().withSection("Singular model building");
                                try {
                                    baked = ChiseledBlockBakedModelManager.getInstance().get(filtered, blockInformation, ChiselRenderType.fromLayer(renderType, false), neighborhood, tileEntity.method_11016(), renderType);
                                }
                                finally {
                                    if (ignored4 != null) {
                                        ignored4.close();
                                    }
                                }
                            }
                        }
                        result.put((Object)renderType, (Object)blockInformation, (Object)baked);
                    }
                }
                return result;
            }
        }, recalculationService).thenAcceptAsync((Consumer)resultConsumer, (Executor)recalculationService);
    }

    private static synchronized void ensureThreadPoolSetup() {
        if (recalculationService == null) {
            ClassLoader classLoader = ChiselsAndBits.class.getClassLoader();
            AtomicInteger genericThreadCounter = new AtomicInteger();
            recalculationService = Executors.newFixedThreadPool(IClientConfiguration.getInstance().getModelBuildingThreadCount().get(), runnable -> {
                Thread thread = new Thread(runnable);
                thread.setContextClassLoader(classLoader);
                thread.setName(String.format("Chisels and Bits Model builder #%s", genericThreadCounter.incrementAndGet()));
                thread.setDaemon(true);
                return thread;
            });
        }
    }
}

