/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face.model;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import mod.chiselsandbits.client.model.baked.BakedQuadBuilder;
import mod.chiselsandbits.client.model.baked.face.model.VertexData;
import net.minecraft.class_293;
import net.minecraft.class_296;

public class BakedQuadAdapter
extends BakedQuadBuilder {
    private final Int2ObjectMap<VertexData> indexToVertexData = new Int2ObjectOpenHashMap();
    private final int colorOverride;

    public BakedQuadAdapter(Collection<VertexData> adaptionData, int colorOverride) {
        adaptionData.forEach(data -> this.indexToVertexData.put(data.vertexIndex(), data));
        this.colorOverride = colorOverride;
    }

    @Override
    public void put(int vertexIndex, int elementIndex, float ... data) {
        if (this.indexToVertexData.containsKey(vertexIndex)) {
            class_293 format = this.getVertexFormat();
            class_296 element = (class_296)format.method_1357().get(elementIndex);
            if (element.method_35667()) {
                VertexData vertexData = (VertexData)this.indexToVertexData.get(vertexIndex);
                float[] positionData = vertexData.positionData();
                super.put(vertexIndex, elementIndex, positionData);
            } else if (element.method_1382() == class_296.class_298.field_1636 && element.method_1385() == 0) {
                VertexData vertexData = (VertexData)this.indexToVertexData.get(vertexIndex);
                float[] uvData = vertexData.uvData();
                super.put(vertexIndex, elementIndex, uvData);
            } else if (element.method_1382() == class_296.class_298.field_1632 && this.colorOverride != -1) {
                float[] colorData = new float[]{(float)(this.colorOverride >> 16 & 0xFF) / 255.0f, (float)(this.colorOverride >> 8 & 0xFF) / 255.0f, (float)(this.colorOverride & 0xFF) / 255.0f, (float)(this.colorOverride >> 24 & 0xFF) / 255.0f};
                super.put(vertexIndex, elementIndex, colorData);
            } else {
                super.put(vertexIndex, elementIndex, data);
            }
        } else {
            super.put(vertexIndex, elementIndex, data);
        }
    }
}

