/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import com.communi.suggestu.scena.core.client.fluid.IClientFluidManager;
import com.communi.suggestu.scena.core.client.models.baked.IDataAwareBakedModel;
import com.communi.suggestu.scena.core.client.rendering.IRenderingManager;
import com.communi.suggestu.scena.core.fluid.FluidInformation;
import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.client.color.IBlockInformationColorManager;
import mod.chiselsandbits.api.client.variant.state.IClientStateVariantManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.client.model.baked.face.model.ModelVertexRange;
import mod.chiselsandbits.client.model.baked.simple.SimpleGeneratedModel;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.LightUtil;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class FaceManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_5819 RANDOM = class_5819.method_43049((long)42L);
    private static final FaceManager INSTANCE = new FaceManager();
    private final SimpleMaxSizedCache<Key, Collection<ModelQuadLayer>> cache = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getFaceLayerCacheSize())::get);
    private final SimpleMaxSizedCache<IBlockInformation, Integer> colorCache = new SimpleMaxSizedCache(() -> IPlatformRegistryManager.getInstance().getBlockStateIdMap().method_10204() == 0 ? 1000 : IPlatformRegistryManager.getInstance().getBlockStateIdMap().method_10204());

    private FaceManager() {
    }

    public static FaceManager getInstance() {
        return INSTANCE;
    }

    private static Optional<ModelQuadLayer> createQuadLayer(class_777 quad, IBlockInformation blockInformation, class_2350 cullDirection, int stateColor) {
        if (quad.method_3358() != cullDirection) {
            return Optional.empty();
        }
        try {
            class_1058 sprite = FaceManager.findQuadTexture(quad);
            ModelQuadLayer.Builder layerBuilder = ModelQuadLayer.Builder.create(blockInformation);
            layerBuilder.setTexture(sprite);
            layerBuilder.withColor(stateColor);
            layerBuilder.withSourceQuad(quad);
            LightUtil.put(layerBuilder, quad);
            return Optional.of(layerBuilder.build());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to process quad: " + quad, (Throwable)ex);
            return Optional.empty();
        }
    }

    private static class_1087 solveModel(IBlockInformation state, class_1087 originalModel, long primaryStateRenderSeed, class_1921 renderType) {
        class_1799 is;
        boolean hasFaces;
        try {
            hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed, renderType);
            for (class_2350 f : class_2350.values()) {
                hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed, renderType);
            }
        }
        catch (Exception e) {
            hasFaces = false;
        }
        if (!hasFaces && !(is = ItemStackUtils.getItemStackFromBlockState(state)).method_7960()) {
            class_1087 itemModel = class_310.method_1551().method_1480().method_4019(is, (class_1937)class_310.method_1551().field_1687, (class_1309)class_310.method_1551().field_1724, 0);
            try {
                hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed, renderType);
                for (class_2350 f : class_2350.values()) {
                    hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed, renderType);
                }
            }
            catch (Exception e) {
                hasFaces = false;
            }
            if (hasFaces) {
                return itemModel;
            }
            return new SimpleGeneratedModel(FaceManager.findTexture(state, originalModel, class_2350.field_11036, primaryStateRenderSeed, renderType));
        }
        return originalModel;
    }

    private static boolean hasFaces(class_1087 model, IBlockInformation state, class_2350 f, long primaryStateRenderSeed, class_1921 renderType) {
        List<class_777> quads = FaceManager.getModelQuads(model, state, f, primaryStateRenderSeed, renderType);
        if (quads == null || quads.isEmpty()) {
            return false;
        }
        class_1058 texture = null;
        try {
            texture = FaceManager.findTexture(null, quads, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModelVertexRange vertexRangeExtractor = new ModelVertexRange();
        for (class_777 quad : quads) {
            LightUtil.put(vertexRangeExtractor, quad);
        }
        return vertexRangeExtractor.getLargestRange() > 0.0f && !FaceManager.isMissingTexture(texture);
    }

    public static class_1058 findTexture(IBlockInformation state, class_1087 model, class_2350 myFace, long primaryStateRenderSeed, class_1921 renderType) {
        class_1058 texture = null;
        if (model != null) {
            try {
                texture = FaceManager.findTexture(null, FaceManager.getModelQuads(model, state, myFace, primaryStateRenderSeed, renderType), myFace);
                if (texture == null) {
                    for (class_2350 side : class_2350.values()) {
                        texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, side, primaryStateRenderSeed, renderType), side);
                    }
                    texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, null, primaryStateRenderSeed, renderType), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                if (model != null) {
                    texture = model.method_4711();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                texture = class_310.method_1551().method_1541().method_3351().method_3339(state.getBlockState());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            texture = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(new class_2960("missingno"));
        }
        return texture;
    }

    private static class_1058 findTexture(class_1058 texture, List<class_777> faceQuads, class_2350 myFace) throws IllegalArgumentException, NullPointerException {
        for (class_777 q : faceQuads) {
            if (q.method_3358() != myFace) continue;
            texture = FaceManager.findQuadTexture(q);
        }
        return texture;
    }

    private static class_1058 findQuadTexture(class_777 q) throws IllegalArgumentException, NullPointerException {
        if (q.method_35788() == null) {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }
        return q.method_35788();
    }

    private static boolean isMissingTexture(class_1058 sprite) {
        if (sprite == null) {
            return true;
        }
        return sprite.method_45851().method_45816().equals((Object)class_1047.method_4539());
    }

    private static List<class_777> getModelQuads(class_1087 model, IBlockInformation state, class_2350 f, long primaryStateRenderSeed, class_1921 renderType) {
        RANDOM.method_43052(primaryStateRenderSeed);
        try {
            if (model instanceof IDataAwareBakedModel) {
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)model;
                return dataAwareBakedModel.getQuads(state.getBlockState(), f, RANDOM, IClientStateVariantManager.getInstance().getBlockModelData(state), renderType);
            }
            return model.method_4707(state.getBlockState(), f, RANDOM);
        }
        catch (Throwable dataAwareBakedModel) {
            try {
                if (model instanceof IDataAwareBakedModel) {
                    IDataAwareBakedModel dataAwareBakedModel2 = (IDataAwareBakedModel)model;
                    return dataAwareBakedModel2.getQuads(null, f, RANDOM, IClientStateVariantManager.getInstance().getBlockModelData(state), renderType);
                }
                return model.method_4707(null, f, RANDOM);
            }
            catch (Throwable dataAwareBakedModel2) {
                class_1087 secondModel;
                class_1799 is = ItemStackUtils.getItemStackFromBlockState(state);
                if (!is.method_7960() && (secondModel = FaceManager.getOverrides(model).method_3495(model, is, class_310.method_1551().field_1687, (class_1309)class_310.method_1551().field_1724, 0)) != null) {
                    try {
                        if (secondModel instanceof IDataAwareBakedModel) {
                            IDataAwareBakedModel dataAwareBakedModel3 = (IDataAwareBakedModel)secondModel;
                            return dataAwareBakedModel3.getQuads(state.getBlockState(), f, RANDOM, IClientStateVariantManager.getInstance().getBlockModelData(state), renderType);
                        }
                        return secondModel.method_4707(state.getBlockState(), f, RANDOM);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return Collections.emptyList();
            }
        }
    }

    private static class_806 getOverrides(class_1087 model) {
        if (model != null) {
            return model.method_4710();
        }
        return class_806.field_4292;
    }

    private static void injectFluidVertexDataForSide(ModelQuadLayer.Builder builder, float minU, float maxU, float minV, float maxV, class_2350 cullDirection) {
        if (cullDirection == null) {
            return;
        }
        switch (cullDirection) {
            case field_11033: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(0.0f).withY(0.0f).withZ(1.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(0.0f).withY(0.0f).withZ(0.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(1.0f).withY(0.0f).withZ(1.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(1.0f).withY(0.0f).withZ(0.0f).withU(maxU).withV(minV));
                break;
            }
            case field_11036: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(0.0f).withY(1.0f).withZ(0.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(0.0f).withY(1.0f).withZ(1.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(1.0f).withY(1.0f).withZ(1.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(1.0f).withY(1.0f).withZ(0.0f).withU(maxU).withV(minV));
                break;
            }
            case field_11043: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(1.0f).withY(1.0f).withZ(0.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(1.0f).withY(0.0f).withZ(0.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(0.0f).withY(0.0f).withZ(0.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(0.0f).withY(1.0f).withZ(0.0f).withU(maxU).withV(minV));
                break;
            }
            case field_11035: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(0.0f).withY(1.0f).withZ(1.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(0.0f).withY(0.0f).withZ(1.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(1.0f).withY(0.0f).withZ(1.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(1.0f).withY(1.0f).withZ(1.0f).withU(maxU).withV(minV));
                break;
            }
            case field_11039: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(0.0f).withY(1.0f).withZ(0.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(0.0f).withY(0.0f).withZ(0.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(0.0f).withY(0.0f).withZ(1.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(0.0f).withY(1.0f).withZ(1.0f).withU(maxU).withV(minV));
                break;
            }
            case field_11034: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(1.0f).withY(1.0f).withZ(1.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(1.0f).withY(0.0f).withZ(1.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(1.0f).withY(0.0f).withZ(0.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(1.0f).withY(1.0f).withZ(0.0f).withU(maxU).withV(minV));
            }
        }
    }

    public void clearCache() {
        this.cache.clear();
        this.colorCache.clear();
    }

    public Collection<ModelQuadLayer> getCachedLayersFor(IBlockInformation state, class_2350 face, class_1921 layer, long primaryStateRenderSeed, @NotNull class_1921 renderType) {
        if (layer == null) {
            return null;
        }
        Key key = new Key(state, layer, face, primaryStateRenderSeed, renderType);
        return this.cache.get(key, () -> this.buildFaceQuadLayers(state, face, primaryStateRenderSeed, renderType));
    }

    private List<ModelQuadLayer> buildFaceQuadLayers(IBlockInformation blockInformation, class_2350 cullDirection, long primaryStateRenderSeed, @NotNull class_1921 renderType) {
        class_1087 model = FaceManager.solveModel(blockInformation, class_310.method_1551().method_1541().method_3351().method_3335(blockInformation.getBlockState()), primaryStateRenderSeed, renderType);
        int lv = IClientConfiguration.getInstance().getUseGetLightValue().get() != false ? blockInformation.getBlockState().method_26213() : 0;
        class_3611 fluid = blockInformation.getBlockState().method_26227().method_15772();
        if (fluid != class_3612.field_15906) {
            ModelQuadLayer.Builder builder = ModelQuadLayer.Builder.create(blockInformation);
            builder.setQuadOrientation(cullDirection);
            builder.withColor(IClientFluidManager.getInstance().getFluidColor(new FluidInformation(fluid)));
            builder.withLight(lv);
            class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(IRenderingManager.getInstance().getFlowingFluidTexture(fluid));
            if (cullDirection.method_10166() == class_2350.class_2351.field_11052) {
                sprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(IRenderingManager.getInstance().getStillFluidTexture(fluid));
            }
            float minV = sprite.method_4593();
            float maxU = sprite.method_4580((double)(256.0f / (float)sprite.method_45851().method_45807()));
            float minU = sprite.method_4594();
            float maxV = sprite.method_4570((double)(256.0f / (float)sprite.method_45851().method_45815()));
            builder.withSprite(sprite);
            FaceManager.injectFluidVertexDataForSide(builder, minU, maxU, minV, maxV, cullDirection);
            builder.setQuadTint(255);
            return Collections.singletonList(builder.build());
        }
        ArrayList layers = Lists.newArrayList();
        int color = this.getColorFor(blockInformation);
        if (model != null) {
            List<class_777> quads = FaceManager.getModelQuads(model, blockInformation, cullDirection, primaryStateRenderSeed, renderType);
            quads.forEach(quad -> FaceManager.createQuadLayer(quad, blockInformation, cullDirection, color).ifPresent(layers::add));
        }
        return layers;
    }

    private int getColorFor(IBlockInformation state) {
        return this.colorCache.get(state, () -> {
            class_1799 target;
            Optional<Integer> dynamicColor = IBlockInformationColorManager.getInstance().getColor(state);
            if (dynamicColor.isPresent()) {
                return dynamicColor.get();
            }
            class_3611 fluid = state.getBlockState().method_26227().method_15772();
            int out = fluid != class_3612.field_15906 ? IClientFluidManager.getInstance().getFluidColor(fluid) : ((target = ItemStackUtils.getItemStackFromBlockState(state)).method_7960() ? 0xFFFFFF : class_310.method_1551().field_1760.method_1704(target, 0));
            return out;
        });
    }

    private record Key(IBlockInformation blockState, class_1921 renderType, class_2350 direction, long primaryStateSeed, class_1921 type) {
    }
}

