/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.replace;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LambdaExceptionUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ReplaceChiselingMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final class_5250 displayName;
    private final class_5250 multiLineDisplayName;
    private final class_2960 iconName;

    public ReplaceChiselingMode(class_5250 displayName, class_5250 multiLineDisplayName, class_2960 iconName) {
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(class_1657 player, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(player, context);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(player));){
                IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(player);
                if (heldBlockState.isAir()) {
                    ClickProcessingState clickProcessingState = ClickProcessingState.DEFAULT;
                    return clickProcessingState;
                }
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                int missingBitCount = (int)mutator.stream().filter(filter).count();
                IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(player);
                if (!player.method_7337() && !playerBitInventory.canExtract(heldBlockState, missingBitCount)) {
                    context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().method_26204().method_9518()));
                    ClickProcessingState clickProcessingState = ClickProcessingState.DEFAULT;
                    return clickProcessingState;
                }
                int totalModifiedStates = mutator.inWorldMutableStream().filter(filter).mapToInt(LambdaExceptionUtils.rethrowToIntFunction(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.overrideState(heldBlockState);
                    });
                })).sum();
                if (totalModifiedStates == 0) {
                    context.setError(LocalStrings.ChiselAttemptFailedNoValidStateFound.getText());
                }
                if (!player.method_7337()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(player, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(class_1657 Player, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(class_1657 Player, IChiselingContext context) {
        return this.onLeftClickBy(Player, context);
    }

    @Override
    public void onStoppedRightClicking(class_1657 Player, IChiselingContext context) {
    }

    @Override
    public boolean isStillValid(class_1657 Player, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional<Set<class_2382>> validPositions = context.getMetadata(ModMetadataKeys.VALID_POSITIONS.get());
        Optional<class_2350> targetedSide = context.getMetadata(ModMetadataKeys.TARGETED_SIDE.get());
        Optional<class_2338> targetedBlockPos = context.getMetadata(ModMetadataKeys.TARGETED_BLOCK.get());
        if (validPositions.isEmpty() || targetedSide.isEmpty() || targetedBlockPos.isEmpty()) {
            return false;
        }
        class_239 hitResult = RayTracingUtils.rayTracePlayer(Player);
        if (hitResult.method_17783() != class_239.class_240.field_1332 || !(hitResult instanceof class_3965)) {
            return false;
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        if (blockHitResult.method_17780() != targetedSide.get()) {
            return false;
        }
        Function<class_2350, class_243> placementFacingAdapter = modeOfOperation == ChiselingOperation.CHISELING ? face -> class_243.method_24954((class_2382)face.method_10153().method_10163()) : face -> class_243.method_24954((class_2382)face.method_10163());
        class_243 hitVector = blockHitResult.method_17784().method_1019(placementFacingAdapter.apply(blockHitResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_2338 hitPos = VectorUtils.toBlockPos(hitVector);
        class_243 hitBlockPosVector = class_243.method_24954((class_2382)hitPos);
        class_243 inBlockHitVector = hitVector.method_1020(hitBlockPosVector);
        class_2382 selectedPosition = VectorUtils.toInteger(inBlockHitVector.method_10216() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.method_10214() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.method_10215() * (double)StateEntrySize.current().getBitsPerBlockSide());
        return validPositions.get().contains(selectedPosition) && hitPos.equals((Object)targetedBlockPos.get());
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(class_1657 Player, IChiselingContext context) {
        class_239 hitResult = RayTracingUtils.rayTracePlayer(Player);
        if (hitResult.method_17783() != class_239.class_240.field_1332 || !(hitResult instanceof class_3965)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        Function<class_2350, class_243> placementFacingAdapter = face -> class_243.method_24954((class_2382)face.method_10153().method_10163());
        class_243 hitVector = blockHitResult.method_17784().method_1019(placementFacingAdapter.apply(blockHitResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_2338 hitPos = VectorUtils.toBlockPos(hitVector);
        class_243 hitBlockPosVector = class_243.method_24954((class_2382)hitPos);
        class_243 inBlockHitVector = hitVector.method_1020(hitBlockPosVector);
        LinkedList<class_2382> toProcess = new LinkedList<class_2382>();
        IWorldAreaMutator worldAccessor = IMutatorFactory.getInstance().in(context.getWorld(), hitPos);
        HashSet validPositions = new HashSet();
        class_2382 selectedPosition = VectorUtils.toInteger(inBlockHitVector.method_10216() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.method_10214() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.method_10215() * (double)StateEntrySize.current().getBitsPerBlockSide());
        toProcess.addLast(selectedPosition);
        class_243 selectedInBlockPosition = class_243.method_24954((class_2382)selectedPosition).method_18806(StateEntrySize.current().getSizePerBitScalingVector());
        Optional<IStateEntryInfo> targetedInfo = worldAccessor.getInAreaTarget(selectedInBlockPosition);
        if (targetedInfo.isEmpty()) {
            context.setError(LocalStrings.ChiselAttemptFailedTargetedBlockNotChiselable.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        worldAccessor.stream().filter(state -> state.getBlockInformation().equals(((IStateEntryInfo)targetedInfo.get()).getBlockInformation())).map(state -> state.getStartPoint().method_18806(StateEntrySize.current().getBitsPerBlockSideScalingVector())).map(position -> VectorUtils.toInteger(position.method_10216(), position.method_10214(), position.method_10215())).forEach(validPositions::add);
        context.include(hitPos, class_243.field_1353);
        context.include(hitPos, new class_243(0.9999, 0.9999, 0.9999));
        context.setStateFilter(accessor -> new SelectedBitStateFilter(validPositions));
        context.setMetadata(ModMetadataKeys.VALID_POSITIONS.get(), validPositions);
        context.setMetadata(ModMetadataKeys.TARGETED_SIDE.get(), blockHitResult.method_17780());
        context.setMetadata(ModMetadataKeys.TARGETED_BLOCK.get(), hitPos);
        return Optional.empty();
    }

    @Override
    public boolean requiresPlaceableEditStack() {
        return true;
    }

    @Override
    public class_265 getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return class_259.method_1073();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public class_2561 getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class SelectedBitStateFilter
    implements Predicate<IStateEntryInfo> {
        private final Set<class_2382> validPositions;

        public SelectedBitStateFilter(Set<class_2382> validPositions) {
            this.validPositions = validPositions;
        }

        @Override
        public boolean test(IStateEntryInfo iStateEntryInfo) {
            class_2382 position = VectorUtils.toInteger(iStateEntryInfo.getStartPoint().method_10216() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().method_10214() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().method_10215() * (double)StateEntrySize.current().getBitsPerBlockSide());
            return this.validPositions.contains(position);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectedBitStateFilter)) {
                return false;
            }
            SelectedBitStateFilter that = (SelectedBitStateFilter)o;
            return this.validPositions.equals(that.validPositions);
        }

        public int hashCode() {
            return this.validPositions.hashCode();
        }

        public String toString() {
            return "SelectedBitStateFilter{validPositions=" + this.validPositions + "}";
        }
    }
}

