/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.permissions.IPermissionHandler;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ChiselingContext
implements IChiselingContext {
    private final class_1936 world;
    private final IChiselMode chiselMode;
    private final ChiselingOperation modeOfOperandus;
    private final boolean simulation;
    private final Runnable onCompleteCallback;
    private final boolean supportsDamaging;
    private final class_1657 playerEntity;
    private boolean complete = false;
    private IWorldAreaMutator mutator = null;
    private Function<IAreaAccessor, Predicate<IStateEntryInfo>> filterBuilder = null;
    private Map<IMetadataKey<?>, Object> metadataKeyMap = Maps.newHashMap();
    private class_1799 causingItemStack;
    private class_5250 error = null;

    public ChiselingContext(class_1936 world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean simulation, Runnable onCompleteCallback, class_1799 causingItemStack, class_1657 playerEntity) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.simulation = simulation;
        this.onCompleteCallback = onCompleteCallback;
        this.modeOfOperandus = modeOfOperandus;
        this.causingItemStack = causingItemStack;
        this.supportsDamaging = this.causingItemStack.method_7909() instanceof IChiselingItem ? ((IChiselingItem)this.causingItemStack.method_7909()).isDamageableDuringChiseling() : false;
        this.playerEntity = playerEntity;
    }

    private ChiselingContext(class_1936 world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean complete, IWorldAreaMutator mutator, class_1657 playerEntity, class_5250 error) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.causingItemStack = class_1799.field_8037;
        this.supportsDamaging = false;
        this.onCompleteCallback = () -> {};
        this.simulation = true;
        this.modeOfOperandus = modeOfOperandus;
        this.complete = complete;
        this.mutator = mutator;
        this.playerEntity = playerEntity;
        this.error = error;
    }

    private ChiselingContext(class_1936 world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean complete, class_1657 playerEntity, class_5250 error) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.causingItemStack = class_1799.field_8037;
        this.supportsDamaging = false;
        this.onCompleteCallback = () -> {};
        this.simulation = true;
        this.modeOfOperandus = modeOfOperandus;
        this.complete = complete;
        this.playerEntity = playerEntity;
        this.error = error;
    }

    private void setMetadataKeyMap(Map<IMetadataKey<?>, Object> metadataKeyMap) {
        this.metadataKeyMap = metadataKeyMap;
    }

    @Override
    @NotNull
    public Optional<IWorldAreaMutator> getMutator() {
        if (this.mutator == null || this.playerEntity == null || !(this.world instanceof class_1937)) {
            return Optional.ofNullable(this.mutator);
        }
        if (!IPermissionHandler.getInstance().canManipulate(this.playerEntity, this.mutator)) {
            this.mutator = null;
            return Optional.empty();
        }
        return Optional.of(this.mutator);
    }

    @Override
    @NotNull
    public class_1936 getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public IChiselMode getMode() {
        return this.chiselMode;
    }

    @Override
    @NotNull
    public IChiselingContext include(class_243 worldPosition) {
        if (this.getMutator().map(m -> !m.isInside(worldPosition)).orElse(true).booleanValue()) {
            if (this.getMutator().isPresent()) {
                IWorldAreaMutator worldAreaMutator = this.getMutator().get();
                class_243 start = new class_243(Math.min(worldPosition.method_10216(), worldAreaMutator.getInWorldStartPoint().method_10216()), Math.min(worldPosition.method_10214(), worldAreaMutator.getInWorldStartPoint().method_10214()), Math.min(worldPosition.method_10215(), worldAreaMutator.getInWorldStartPoint().method_10215()));
                class_243 end = new class_243(Math.max(worldPosition.method_10216(), worldAreaMutator.getInWorldEndPoint().method_10216()), Math.max(worldPosition.method_10214(), worldAreaMutator.getInWorldEndPoint().method_10214()), Math.max(worldPosition.method_10215(), worldAreaMutator.getInWorldEndPoint().method_10215()));
                this.mutator = IMutatorFactory.getInstance().covering(this.world, start, end);
            } else {
                this.mutator = IMutatorFactory.getInstance().covering(this.world, worldPosition, worldPosition);
            }
        }
        return this;
    }

    @Override
    public void setComplete() {
        this.complete = true;
        this.onCompleteCallback.run();
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isSimulation() {
        return this.simulation;
    }

    @Override
    @NotNull
    public ChiselingOperation getModeOfOperandus() {
        return this.modeOfOperandus;
    }

    @Override
    @NotNull
    public IChiselingContext createSnapshot() {
        ChiselingContext context = this.createInnerSnapshot();
        HashMap newMetadata = Maps.newHashMap();
        for (IMetadataKey<?> key : this.metadataKeyMap.keySet()) {
            Optional<?> value = this.snapshotMetadata(key);
            value.ifPresent(o -> newMetadata.put(key, o));
        }
        context.setMetadataKeyMap(newMetadata);
        return context;
    }

    @NotNull
    private ChiselingContext createInnerSnapshot() {
        if (this.mutator == null) {
            return new ChiselingContext(this.world, this.chiselMode, this.modeOfOperandus, this.complete, this.playerEntity, this.error);
        }
        return new ChiselingContext(this.world, this.chiselMode, this.modeOfOperandus, this.complete, IMutatorFactory.getInstance().covering(this.world, this.mutator.getInWorldStartPoint(), this.mutator.getInWorldEndPoint()), this.playerEntity, this.error);
    }

    private <T> Optional<T> snapshotMetadata(IMetadataKey<T> key) {
        Optional<Object> value = this.getMetadata(key);
        return value.map(key::snapshot);
    }

    @Override
    public int tryDamageItemAndDo(int damage, Runnable onDamaged, Runnable onBroken) {
        if (!this.supportsDamaging || this.simulation) {
            onDamaged.run();
            return damage;
        }
        if (this.causingItemStack.method_7960()) {
            onBroken.run();
            return 0;
        }
        AtomicBoolean broken = new AtomicBoolean(false);
        int currentDamage = this.causingItemStack.method_7919();
        this.causingItemStack.method_7956(damage, (class_1309)this.playerEntity, playerEntity -> {
            broken.set(true);
            class_1268 hand = class_1268.field_5808;
            if (playerEntity.method_6079() == this.causingItemStack) {
                hand = class_1268.field_5810;
            }
            playerEntity.method_20236(hand);
        });
        onDamaged.run();
        if (broken.get()) {
            this.causingItemStack = class_1799.field_8037;
        }
        return Math.min(damage, currentDamage);
    }

    @Override
    public void setStateFilter(@NotNull Function<IAreaAccessor, Predicate<IStateEntryInfo>> filter) {
        this.filterBuilder = filter;
    }

    @Override
    public void clearStateFilter() {
        this.filterBuilder = null;
    }

    @Override
    public Optional<Function<IAreaAccessor, Predicate<IStateEntryInfo>>> getStateFilter() {
        return Optional.ofNullable(this.filterBuilder);
    }

    @Override
    public <T> Optional<T> getMetadata(IMetadataKey<T> key) {
        Object value = this.metadataKeyMap.get(key);
        if (value == null) {
            return Optional.empty();
        }
        try {
            Object castValue = value;
            return Optional.ofNullable(castValue);
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    public void removeMetadata(IMetadataKey<?> key) {
        this.metadataKeyMap.remove(key);
    }

    @Override
    public <T> void setMetadata(IMetadataKey<T> key, T value) {
        this.metadataKeyMap.put(key, value);
    }

    @Override
    public void resetMutator() {
        this.mutator = null;
    }

    @Override
    public void setError(class_5250 errorText) {
        this.error = errorText;
    }

    @Override
    public Optional<class_5250> getError() {
        return Optional.ofNullable(this.error);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(class_243 inAreaTarget) {
        if (this.getMutator().isPresent() && this.getMutator().map(m -> m.isInside(inAreaTarget)).orElse(false).booleanValue()) {
            return this.getMutator().flatMap(m -> m.getInAreaTarget(inAreaTarget));
        }
        class_2338 position = VectorUtils.toBlockPos(inAreaTarget);
        class_243 inBlockOffset = inAreaTarget.method_1023((double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260());
        return IMutatorFactory.getInstance().in(this.getWorld(), position).getInAreaTarget(inBlockOffset);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        return this.getInAreaTarget(class_243.method_24954((class_2382)inAreaBlockPosOffset).method_1019(inBlockTarget));
    }
}

