/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import com.communi.suggestu.scena.core.blockstate.ILevelBasedPropertyAccessor;
import com.communi.suggestu.scena.core.fluid.FluidInformation;
import com.communi.suggestu.scena.core.fluid.IFluidManager;
import java.util.Optional;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.block.BitStorageBlock;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.registrars.ModBlockEntityTypes;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;

public class BitStorageBlockEntity
extends class_2586
implements class_1263 {
    private IBlockInformation state = null;
    private int bits = 0;
    private int oldLV = -1;

    public BitStorageBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntityTypes.BIT_STORAGE.get(), pos, state);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_2487 tag = nbt.method_10562("block_information");
        this.state = new BlockInformation(tag);
        this.bits = nbt.method_10550("bits");
    }

    public void method_11007(@NotNull class_2487 compound) {
        super.method_11007(compound);
        if (this.state != null) {
            compound.method_10566("block_information", this.state.serializeNBT());
            compound.method_10569("bits", this.bits);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38242();
    }

    public boolean addAllPossibleBits(class_1657 playerIn) {
        if (playerIn != null && playerIn.method_5715() && this.state != null && !this.state.isAir()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(playerIn);
            int extractionAmount = Math.min(StateEntrySize.current().getBitsPerBlock() - this.bits, bitInventory.getMaxExtractAmount(this.state));
            bitInventory.extract(this.state, extractionAmount);
            this.bits += extractionAmount;
            this.saveAndUpdate();
        }
        return false;
    }

    private void saveAndUpdate() {
        if (this.field_11863 == null || this.method_10997() == null) {
            return;
        }
        if (this.bits == 0) {
            this.state = null;
        }
        if (this.state == null) {
            this.bits = 0;
        }
        this.method_5431();
        this.method_10997().method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
        int lv = this.getLightValue();
        if (this.oldLV != lv) {
            this.method_10997().method_22336().method_15513(this.method_11016());
            this.oldLV = lv;
        }
    }

    public int getLightValue() {
        return ILevelBasedPropertyAccessor.getInstance().getLightEmission((class_4538)new SingleBlockWorldReader(this.state == null ? BlockInformation.AIR : this.state, this.method_11016(), (class_4538)this.method_10997()), this.method_11016());
    }

    public boolean addHeldBits(class_1799 current, class_1657 playerIn) {
        if (current.method_7960()) {
            return false;
        }
        if (playerIn.method_5715() || this.bits == 0) {
            Optional containedFluid;
            IBlockInformation stackState;
            class_1792 class_17922 = current.method_7909();
            if (class_17922 instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)class_17922;
                if (bitItem.getBlockInformation(current) == this.state || this.state == null) {
                    this.state = bitItem.getBlockInformation(current);
                    int maxToInsert = StateEntrySize.current().getBitsPerBlock() - this.bits;
                    int toInsert = Math.min(maxToInsert, current.method_7947());
                    this.bits += toInsert;
                    if (!playerIn.method_7337()) {
                        current.method_7934(toInsert);
                        playerIn.method_31548().method_5447(playerIn.method_31548().field_7545, current);
                        playerIn.method_31548().method_5431();
                    }
                    this.saveAndUpdate();
                    return true;
                }
            } else if (IEligibilityManager.getInstance().canBeChiseled(current) && (stackState = ItemStackUtils.getStateFromItem(current)).getBlockState().method_26204() != class_2246.field_10124 && (this.state == null || this.state.isAir())) {
                this.state = stackState;
                this.bits = StateEntrySize.current().getBitsPerBlock();
                if (!playerIn.method_7337()) {
                    current.method_7934(1);
                    playerIn.method_31548().method_5447(playerIn.method_31548().field_7545, current);
                    playerIn.method_31548().method_5431();
                }
                this.saveAndUpdate();
                return true;
            }
            if ((containedFluid = IFluidManager.getInstance().get(current)).isPresent() && ((FluidInformation)containedFluid.get()).amount() > 0L) {
                class_2680 state = ((FluidInformation)containedFluid.get()).fluid().method_15785().method_15759();
                BlockInformation blockInformation = new BlockInformation(state, IStateVariantManager.getInstance().getStateVariant((FluidInformation)containedFluid.get()));
                if (IEligibilityManager.getInstance().canBeChiseled(blockInformation) && (this.state == null || blockInformation.isAir())) {
                    int maxToInsert = StateEntrySize.current().getBitsPerBlock() - this.bits;
                    int toInsert = (int)Math.min((float)maxToInsert, this.getBitCountFrom((FluidInformation)containedFluid.get()));
                    this.state = blockInformation;
                    this.bits += toInsert;
                    if (!playerIn.method_7337()) {
                        class_1799 resultStack = IFluidManager.getInstance().extractFrom(current, (long)toInsert);
                        playerIn.method_31548().method_5447(playerIn.method_31548().field_7545, resultStack);
                        playerIn.method_31548().method_5431();
                    }
                    this.saveAndUpdate();
                    return true;
                }
            }
        }
        return false;
    }

    private float getBitCountFrom(FluidInformation containedFluid) {
        return (float)StateEntrySize.current().getBitsPerBlock() * ((float)containedFluid.amount() / (float)IFluidManager.getInstance().getBucketAmount());
    }

    public boolean extractBits(class_1657 playerIn) {
        if (!playerIn.method_5715()) {
            class_1792 class_17922;
            class_1799 is = this.method_5438(0);
            if (!is.method_7960() && (class_17922 = is.method_7909()) instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)class_17922;
                IBlockInformation blockState = bitItem.getBlockInformation(is);
                BitInventoryUtils.insertIntoOrSpawn(playerIn, blockState, is.method_7947());
                this.method_5434(0, is.method_7947());
            }
            return true;
        }
        return false;
    }

    public IBlockInformation getContainedBlockInformation() {
        return this.state;
    }

    public int getBits() {
        return this.bits;
    }

    public class_2350 getFacing() {
        return (class_2350)this.method_10997().method_8320(this.method_11016()).method_11654(BitStorageBlock.FACING);
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return this.state == null || this.bits == 0;
    }

    @NotNull
    public class_1799 method_5438(int index) {
        if (index != 0) {
            return class_1799.field_8037;
        }
        if (this.state == null) {
            return class_1799.field_8037;
        }
        return IBitItemManager.getInstance().create(this.state, Math.min(64, this.bits));
    }

    @NotNull
    public class_1799 method_5434(int index, int count) {
        if (index != 0) {
            return class_1799.field_8037;
        }
        IBlockInformation currentState = this.state;
        int toRemove = Math.min(count, this.bits);
        this.bits -= toRemove;
        this.saveAndUpdate();
        return IBitItemManager.getInstance().create(currentState, toRemove);
    }

    @NotNull
    public class_1799 method_5441(int index) {
        return class_1799.field_8037;
    }

    public void method_5447(int index, @NotNull class_1799 itemStack) {
        if (index != 0 || !(itemStack.method_7909() instanceof IBitItem) || ((IBitItem)itemStack.method_7909()).getBlockInformation(itemStack) == this.state) {
            return;
        }
        this.saveAndUpdate();
        this.bits = Math.max(StateEntrySize.current().getBitsPerBlock(), this.bits + itemStack.method_7947());
    }

    public boolean method_5443(@NotNull class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > 64.0);
    }

    public void method_5448() {
        this.state = null;
        this.bits = 0;
        this.saveAndUpdate();
    }

    public Optional<FluidInformation> getFluid() {
        if (!this.containsFluid()) {
            return Optional.empty();
        }
        long amount = (long)((float)this.bits / ((float)StateEntrySize.current().getBitsPerBlock() / (float)IFluidManager.getInstance().getBucketAmount()));
        Optional<FluidInformation> dynamicFluid = IStateVariantManager.getInstance().getFluidInformation(this.state, amount);
        if (dynamicFluid.isPresent()) {
            return dynamicFluid;
        }
        return Optional.of(new FluidInformation(((class_2404)this.state.getBlockState().method_26204()).method_9545(this.state.getBlockState()).method_15772(), amount, new class_2487()));
    }

    public boolean containsFluid() {
        class_2404 liquidBlock;
        if (this.state == null) {
            return false;
        }
        long amount = (long)((float)this.bits / ((float)StateEntrySize.current().getBitsPerBlock() / (float)IFluidManager.getInstance().getBucketAmount()));
        Optional<FluidInformation> dynamicFluid = IStateVariantManager.getInstance().getFluidInformation(this.state, amount);
        if (dynamicFluid.isPresent()) {
            return true;
        }
        class_2248 class_22482 = this.state.getBlockState().method_26204();
        return class_22482 instanceof class_2404 && !(liquidBlock = (class_2404)class_22482).method_9545(this.state.getBlockState()).method_15769();
    }

    public void extractBits(int count) {
        this.bits = Math.max(0, this.bits - count);
        if (this.bits <= 0) {
            this.state = null;
        }
        this.saveAndUpdate();
    }

    public void insertBits(int bitCountToInsert, IBlockInformation blockInformation) {
        if (this.state == null || blockInformation.equals(this.state)) {
            this.bits = Math.max(StateEntrySize.current().getBitsPerBlock(), bitCountToInsert + this.bits);
            this.state = blockInformation;
            this.saveAndUpdate();
        }
    }

    public void insertBitsFromFluid(FluidInformation fluidInformation) {
        BlockInformation fluidBlockInformation = new BlockInformation(fluidInformation.fluid().method_15785().method_15759(), IStateVariantManager.getInstance().getStateVariant(fluidInformation));
        if (this.state == null || this.state.equals(fluidBlockInformation)) {
            this.bits = (int)Math.max((float)StateEntrySize.current().getBitsPerBlock(), this.getBitCountFrom(fluidInformation) + (float)this.bits);
            this.state = fluidBlockInformation;
            this.saveAndUpdate();
        }
    }

    public void setContents(BlockInformation blockInformation, int count) {
        this.state = blockInformation;
        this.bits = count;
        this.saveAndUpdate();
    }
}

