/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block;

import com.communi.suggestu.saecularia.caudices.core.block.IBlockWithWorldlyProperties;
import com.communi.suggestu.scena.core.blockstate.ILevelBasedPropertyAccessor;
import com.communi.suggestu.scena.core.dist.Dist;
import com.communi.suggestu.scena.core.dist.DistExecutor;
import com.communi.suggestu.scena.core.entity.IPlayerInventoryManager;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemFactory;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.ArrayUtils;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.block.entities.ChiseledBlockEntity;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.client.block.ClientChiseledBlockExtensions;
import mod.chiselsandbits.clipboard.CreativeClipboardUtils;
import mod.chiselsandbits.network.packets.NeighborBlockUpdatedPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_8235;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlock
extends class_2248
implements IMultiStateBlock,
class_3737,
IBlockWithWorldlyProperties {
    private static final Supplier<ClientChiseledBlockExtensions> renderProperties = Suppliers.memoize(ClientChiseledBlockExtensions::new);

    public ChiseledBlock(class_4970.class_2251 properties) {
        super(properties.method_26245(ChiseledBlock::isViewBlocking).method_22488());
    }

    private static boolean isViewBlocking(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return false;
    }

    public float getFriction(class_2680 state, class_4538 levelReader, class_2338 pos, @Nullable class_1297 entity) {
        float frictionValue = ChiseledBlock.getBlockEntity((class_1922)levelReader, pos).map(multiStateBlockEntity -> Float.valueOf(multiStateBlockEntity.getStatistics().getSlipperiness())).orElse(Float.valueOf(0.0f)).floatValue();
        return Float.isNaN(frictionValue) || frictionValue <= 1.0E-4f ? 0.6f : frictionValue;
    }

    public int getLightEmission(class_2680 state, class_1922 blockGetter, class_2338 pos) {
        return ChiseledBlock.getBlockEntity(blockGetter, pos).map(multiStateBlockEntity -> Float.valueOf((float)blockGetter.method_8315() * multiStateBlockEntity.getStatistics().getLightEmissionFactor())).map(inertValue -> (double)inertValue.floatValue() * IServerConfiguration.getInstance().getLightFactorMultiplier().get()).map(consumedValue -> Math.max(consumedValue, 0.0)).map(consumedValue -> Math.min(consumedValue, (double)blockGetter.method_8315())).orElse(0.0).intValue();
    }

    public boolean canHarvestBlock(class_2680 state, class_1922 blockGetter, class_2338 pos, class_1657 player) {
        return ChiseledBlock.getBlockEntity(blockGetter, pos).map(e -> {
            IBlockInformation primaryState = e.getStatistics().getPrimaryState();
            return ILevelBasedPropertyAccessor.getInstance().canHarvestBlock((class_1922)new SingleBlockBlockReader(primaryState, pos, blockGetter), pos, player);
        }).orElse(true);
    }

    public class_1799 getCloneItemStack(class_2680 state, class_239 target, class_1922 blockGetter, class_2338 pos, class_1657 player) {
        if (!(target instanceof class_3965)) {
            return class_1799.field_8037;
        }
        class_3965 blockRayTraceResult = (class_3965)target;
        if (!IClientConfiguration.getInstance().getInvertPickBlockBehaviour().get().booleanValue() && player.method_5715() || IClientConfiguration.getInstance().getInvertPickBlockBehaviour().get().booleanValue() && !player.method_5715()) {
            return ChiseledBlock.getBlockEntity(blockGetter, pos).map(e -> {
                IMultiStateSnapshot snapshot = e.createSnapshot();
                IMultiStateItemStack multiStateItemStack = snapshot.toItemStack();
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreativeClipboardUtils.addPickedBlock(multiStateItemStack));
                return multiStateItemStack.toBlockStack();
            }).orElse(class_1799.field_8037);
        }
        return ChiseledBlock.getBlockEntity(blockGetter, pos).flatMap(e -> {
            class_243 hitVec = blockRayTraceResult.method_17784();
            class_2338 blockPos = blockRayTraceResult.method_17777();
            class_243 accuratePos = new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
            class_243 faceOffset = new class_243((double)((float)blockRayTraceResult.method_17780().method_10153().method_10148() * StateEntrySize.current().getSizePerHalfBit()), (double)((float)blockRayTraceResult.method_17780().method_10153().method_10164() * StateEntrySize.current().getSizePerHalfBit()), (double)((float)blockRayTraceResult.method_17780().method_10153().method_10165() * StateEntrySize.current().getSizePerHalfBit()));
            class_243 hitDelta = hitVec.method_1020(accuratePos).method_1019(faceOffset);
            try {
                return e.getInAreaTarget(hitDelta);
            }
            catch (IllegalArgumentException exception) {
                return Optional.empty();
            }
        }).map(targetedStateEntry -> IMultiStateItemFactory.getInstance().createBlockFrom((IStateEntryInfo)targetedStateEntry)).orElseGet(() -> ChiseledBlock.getBlockEntity(blockGetter, pos).map(e -> {
            IMultiStateSnapshot snapshot = e.createSnapshot();
            return snapshot.toItemStack().toBlockStack();
        }).orElse(class_1799.field_8037));
    }

    public class_2680 rotate(class_2680 state, class_1936 levelAccessor, class_2338 pos, class_2470 rotation) {
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            if (!rotation.method_26383().method_26387(axis)) continue;
            ChiseledBlock.getBlockEntity((class_1922)levelAccessor, pos).ifPresent(e -> e.rotate(axis));
            return state;
        }
        return state;
    }

    public boolean shouldCheckWeakPower(class_2680 blockState, class_8235 signalGetter, class_2338 blockPos, class_2350 direction) {
        return ChiseledBlock.getBlockEntity((class_1922)signalGetter, blockPos).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().shouldCheckWeakPower()).orElse(false);
    }

    public boolean shouldDisplayFluidOverlay(class_2680 state, class_1920 blockAndTintGetter, class_2338 pos, class_3610 fluidState) {
        return true;
    }

    @NotNull
    private static Optional<IMultiStateBlockEntity> getBlockEntity(class_1922 worldIn, class_2338 pos) {
        class_2586 tileEntity = worldIn.method_8321(pos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            return Optional.empty();
        }
        return Optional.of((IMultiStateBlockEntity)tileEntity);
    }

    public boolean method_9579(@NotNull class_2680 state, @NotNull class_1922 reader, @NotNull class_2338 pos) {
        return ChiseledBlock.getBlockEntity(reader, pos).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().canPropagateSkylight()).orElse(false);
    }

    public boolean method_9526(@NotNull class_2680 blockState) {
        return true;
    }

    public void method_9556(@NotNull class_1937 worldIn, @NotNull class_1657 player, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_2586 te, @NotNull class_1799 stack) {
        if (te instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)te;
            IMultiStateSnapshot snapshot = multiStateBlockEntity.createSnapshot();
            ChiseledBlock.method_9577((class_1937)worldIn, (class_2338)pos, (class_1799)snapshot.toItemStack().toBlockStack());
        }
    }

    public void method_9567(@NotNull class_1937 worldIn, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_1309 placer, @NotNull class_1799 stack) {
        ChiseledBlock.getBlockEntity((class_1922)worldIn, pos).ifPresent(multiStateBlockEntity -> {
            class_2350 placementDirection = placer == null ? class_2350.field_11043 : placer.method_5735().method_10153();
            int horizontalIndex = placementDirection.method_10161();
            int rotationCount = horizontalIndex - 4;
            if (rotationCount < 0) {
                rotationCount += 4;
            }
            multiStateBlockEntity.rotate(class_2350.class_2351.field_11052, rotationCount);
            super.method_9567(worldIn, pos, state, placer, stack);
        });
    }

    public boolean method_9543() {
        return true;
    }

    @Override
    @NotNull
    public IBlockInformation getPrimaryState(@NotNull class_1922 world, @NotNull class_2338 pos) {
        return ChiseledBlock.getBlockEntity(world, pos).map(e -> e.getStatistics().getPrimaryState()).orElse(BlockInformation.AIR);
    }

    public void method_9536(@NotNull class_2680 state, @NotNull class_1937 worldIn, @NotNull class_2338 pos, class_2680 newState, boolean isMoving) {
        if (newState.method_26204() instanceof ChiseledBlock) {
            return;
        }
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    public boolean method_9616(@NotNull class_2680 state, class_1750 useContext) {
        return ChiseledBlock.getBlockEntity((class_1922)useContext.method_8045(), useContext.method_8037()).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().isEmptyBlock()).orElse(true);
    }

    @NotNull
    public class_265 method_25959(@NotNull class_2680 state, @NotNull class_1922 reader, @NotNull class_2338 pos) {
        class_265 shape = ChiseledBlock.getBlockEntity(reader, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity, CollisionType.COLLIDEABLE_ONLY)).orElse(class_259.method_1073());
        return shape.method_1110() ? class_259.method_1077() : shape;
    }

    public float method_9575(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos) {
        return ChiseledBlock.getBlockEntity(worldIn, pos).map(b -> b.getStatistics().isFullBlock()).map(f -> Float.valueOf(f != false ? 0.2f : 1.0f)).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_265 shape = ChiseledBlock.getBlockEntity(worldIn, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity)).orElse(class_259.method_1073());
        return shape.method_1110() ? class_259.method_1077() : shape;
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_265 shape = ChiseledBlock.getBlockEntity(worldIn, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity, CollisionType.COLLIDEABLE_ONLY)).orElse(class_259.method_1073());
        if (shape.method_1110()) {
            boolean justFluids = ChiseledBlock.getBlockEntity(worldIn, pos).map(IAreaAccessor::stream).map(stream -> stream.allMatch(stateEntry -> stateEntry.getBlockInformation().isAir() || !stateEntry.getBlockInformation().getBlockState().method_26227().method_15769())).orElse(false);
            return justFluids ? shape : class_259.method_1077();
        }
        return shape;
    }

    @NotNull
    public class_265 method_26159(@NotNull class_2680 state, @NotNull class_1922 reader, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return this.method_9530(state, reader, pos, context);
    }

    public float method_9594(@NotNull class_2680 state, @NotNull class_1657 player, @NotNull class_1922 worldIn, @NotNull class_2338 pos) {
        return ChiseledBlock.getBlockEntity(worldIn, pos).map(multiStateBlockEntity -> Float.valueOf(multiStateBlockEntity.getStatistics().getRelativeBlockHardness(player))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean method_10310(@NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_2680 state, class_3611 fluidIn) {
        IMultiStateBlockEntity multiStateBlockEntity;
        class_2586 class_25862;
        return IEligibilityManager.getInstance().canBeChiseled(new BlockInformation(fluidIn.method_15785().method_15759(), IStateVariantManager.getInstance().getStateVariant(fluidIn.method_15785()))) && (class_25862 = worldIn.method_8321(pos)) instanceof IMultiStateBlockEntity && (multiStateBlockEntity = (IMultiStateBlockEntity)class_25862).isCanBeFlooded();
    }

    public boolean method_10311(@NotNull class_1936 worldIn, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3610 fluidStateIn) {
        class_3611 still = fluidStateIn.method_15772() instanceof class_3609 ? ((class_3609)fluidStateIn.method_15772()).method_15751() : fluidStateIn.method_15772();
        return ChiseledBlock.getBlockEntity((class_1922)worldIn, pos).map(entity -> {
            try (IBatchMutation ignored = entity.batch();){
                entity.mutableStream().forEach(stateEntry -> {
                    if (stateEntry.getBlockInformation().isAir()) {
                        class_2680 blockState = still.method_15785().method_15759();
                        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(fluidStateIn);
                        try {
                            stateEntry.setBlockInformation(new BlockInformation(blockState, additionalStateInfo));
                        }
                        catch (SpaceOccupiedException spaceOccupiedException) {
                            // empty catch block
                        }
                    }
                });
            }
            return true;
        }).orElse(false);
    }

    @NotNull
    public class_1799 method_9700(@NotNull class_1936 p_154560_, @NotNull class_2338 p_154561_, @NotNull class_2680 p_154562_) {
        return class_1799.field_8037;
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new ChiseledBlockEntity(pos, state);
    }

    public void method_9612(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 position, @NotNull class_2248 block, @NotNull class_2338 otherPosition, boolean update) {
        class_2586 class_25862 = level.method_8321(position);
        if (!(class_25862 instanceof ChiseledBlockEntity)) {
            return;
        }
        ChiseledBlockEntity chiseledBlockEntity = (ChiseledBlockEntity)class_25862;
        if (level.method_8608()) {
            chiseledBlockEntity.updateModelData();
        } else {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToTrackingChunk(new NeighborBlockUpdatedPacket(position, otherPosition), level.method_8500(position));
        }
    }

    public float[] getBeaconColorMultiplier(class_2680 state, class_4538 levelReader, class_2338 pos, class_2338 beaconPos) {
        return ChiseledBlock.getBlockEntity((class_1922)levelReader, pos).filter(e -> e.getStatistics().getStateCounts().keySet().stream().filter(entryState -> !entryState.isAir()).allMatch(entryState -> ILevelBasedPropertyAccessor.getInstance().getBeaconColorMultiplier((class_4538)new SingleBlockWorldReader(e.getStatistics().getPrimaryState(), pos, levelReader), pos, beaconPos) != null)).flatMap(e -> e.getStatistics().getStateCounts().entrySet().stream().filter(entryState -> !((IBlockInformation)entryState.getKey()).isAir()).map(entryState -> ArrayUtils.multiply(ILevelBasedPropertyAccessor.getInstance().getBeaconColorMultiplier((class_4538)new SingleBlockWorldReader((IBlockInformation)entryState.getKey(), pos, levelReader), pos, beaconPos), ((Integer)entryState.getValue()).intValue())).reduce((floats, floats2) -> {
            if (((float[])floats).length != ((float[])floats2).length) {
                return null;
            }
            if (floats == null) {
                return null;
            }
            if (floats2 == null) {
                return null;
            }
            float[] result = new float[((float[])floats).length];
            for (int i = 0; i < ((float[])floats).length; ++i) {
                result[i] = floats[i] + floats2[i];
            }
            return result;
        }).filter(Objects::nonNull).flatMap(summedResult -> ChiseledBlock.getBlockEntity((class_1922)levelReader, pos).map(entity -> ArrayUtils.multiply(summedResult, 1.0f / (entity.getStatistics().getFullnessFactor() * (float)StateEntrySize.current().getBitsPerBlock()))))).orElse(null);
    }

    public class_2498 getSoundType(class_2680 state, class_4538 levelReader, class_2338 pos, @Nullable class_1297 entity) {
        return ChiseledBlock.getBlockEntity((class_1922)levelReader, pos).map(blockEntity -> blockEntity.getStatistics().getPrimaryState()).map(blockState -> ILevelBasedPropertyAccessor.getInstance().getSoundType((class_4538)new SingleBlockWorldReader((IBlockInformation)blockState, pos, levelReader), pos, entity)).orElse(class_2498.field_11544);
    }

    public float getExplosionResistance(class_2680 state, class_1922 blockGetter, class_2338 position, class_1927 explosion) {
        return (float)ChiseledBlock.getBlockEntity(blockGetter, position).map(e -> e.getStatistics().getStateCounts().entrySet().stream().filter(entryState -> !((IBlockInformation)entryState.getKey()).isAir()).mapToDouble(entryState -> ILevelBasedPropertyAccessor.getInstance().getExplosionResistance((class_1922)new SingleBlockBlockReader((IBlockInformation)entryState.getKey(), position, blockGetter), position, explosion) * (float)((Integer)entryState.getValue()).intValue()).sum() / (double)(e.getStatistics().getFullnessFactor() * (float)StateEntrySize.current().getBitsPerBlock())).orElse(0.0).doubleValue();
    }

    public void method_9576(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState, @NotNull class_1657 player) {
        super.method_9576(level, blockPos, blockState, player);
        if (level.method_8608()) {
            ChiseledBlock.getBlockEntity((class_1922)level, blockPos).map(IAreaAccessor::createSnapshot).map(IMultiStateSnapshot::toItemStack).ifPresent(CreativeClipboardUtils::addBrokenBlock);
        }
    }

    public boolean canBeGrass(class_4538 levelReader, class_2680 grassState, class_2338 grassBlockPos, class_2680 targetState, class_2338 targetPosition) {
        return ChiseledBlock.getBlockEntity((class_1922)levelReader, targetPosition).map(blockEntity -> blockEntity.getStatistics().canSustainGrassBelow()).orElse(false);
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 blockHitResult) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8535)) {
            return ChiseledBlock.getBlockEntity((class_1922)level, blockPos).map(blockEntity -> {
                try (IBatchMutation mutation = blockEntity.batch(IChangeTrackerManager.getInstance().getChangeTracker(player));){
                    Long l = blockEntity.mutableStream().filter(entry -> !entry.getBlockInformation().getBlockState().method_26227().method_15769()).peek(IMutableStateEntryInfo::clear).count();
                    return l;
                }
            }).map(count -> {
                if (count > 0L) {
                    itemStack.method_7934(1);
                    IPlayerInventoryManager.getInstance().giveToPlayer(player, new class_1799((class_1935)class_1802.field_8554));
                }
                return count > 0L ? class_1269.field_5812 : class_1269.field_5811;
            }).orElse(class_1269.field_5811);
        }
        if (itemStack.method_31574(class_1802.field_8601)) {
            return ChiseledBlock.getBlockEntity((class_1922)level, blockPos).map(blockEntity -> {
                if (blockEntity.isEmitsLightBasedOnFullBlock()) {
                    blockEntity.setEmitsLightBasedOnFullBlock(false);
                    return class_1269.field_21466;
                }
                return class_1269.field_5811;
            }).orElse(class_1269.field_5811);
        }
        if (itemStack.method_31574(class_1802.field_8226)) {
            return ChiseledBlock.getBlockEntity((class_1922)level, blockPos).map(blockEntity -> {
                if (!blockEntity.isEmitsLightBasedOnFullBlock()) {
                    blockEntity.setEmitsLightBasedOnFullBlock(true);
                    return class_1269.field_21466;
                }
                return class_1269.field_5811;
            }).orElse(class_1269.field_5811);
        }
        if (itemStack.method_31574(class_1802.field_20414)) {
            return ChiseledBlock.getBlockEntity((class_1922)level, blockPos).map(blockEntity -> {
                if (blockEntity.isCanBeFlooded()) {
                    blockEntity.setCanBeFlooded(false);
                    return class_1269.field_21466;
                }
                return class_1269.field_5811;
            }).orElse(class_1269.field_5811);
        }
        if (itemStack.method_31574(class_1802.field_8868)) {
            return ChiseledBlock.getBlockEntity((class_1922)level, blockPos).map(blockEntity -> {
                if (!blockEntity.isCanBeFlooded()) {
                    blockEntity.setCanBeFlooded(true);
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        itemStack.method_7970(1, level.method_8409(), serverPlayer);
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }).orElse(class_1269.field_5811);
        }
        return class_1269.field_5811;
    }

    public ClientChiseledBlockExtensions getRenderProperties() {
        return renderProperties.get();
    }
}

