/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.util;

import java.util.Comparator;
import java.util.Optional;

public class ComparatorUtils {
    private ComparatorUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ComparatorUtils. This is a utility class");
    }

    public static <T extends Comparable<T>> Comparator<Optional<T>> createOptionalComparator() {
        return ComparatorUtils.createOptionalComparator(Comparator.naturalOrder());
    }

    public static <T extends Comparable<T>> Comparator<Optional<T>> createOptionalComparator(Comparator<T> comparator) {
        return (o1, o2) -> {
            if (o1.isPresent() && o2.isPresent()) {
                return comparator.compare((Comparable)o1.get(), (Comparable)o2.get());
            }
            if (o1.isPresent()) {
                return 1;
            }
            if (o2.isPresent()) {
                return -1;
            }
            return 0;
        };
    }
}

